package io.wispforest.alloyforgery.client;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.util.NinePatchTexture;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_10799;
import net.minecraft.class_2960;

import static io.wispforest.owo.ui.container.Containers.horizontalFlow;
import static io.wispforest.owo.ui.container.Containers.verticalFlow;

import I;

public class ComponentUtils {
    public static final ButtonComponent.Renderer BUTTON_RENDERER = createThemedButtonRenderer(AlloyForgery.CONFIG::darkModeTheme);

    public static class_2960 themedTextureID(String suffix) {
        return themedTextureID(suffix, AlloyForgery.CONFIG::darkModeTheme);
    }

    public static class_2960 themedTextureID(String suffix, Supplier<Boolean> isDarkMode) {
        return AlloyForgery.id("textures/gui/theme/" + (isDarkMode.get() ? "dark" : "light") + "/" + suffix);
    }

    public static class_2960 textureID(String suffix) {
        return AlloyForgery.id("textures/gui/" + suffix);
    }

    public static <T> T getThemedValue(T light, T dark) {
        return AlloyForgery.CONFIG.darkModeTheme() ? dark : light;
    }

    public static ButtonComponent.Renderer createThemedButtonRenderer(Supplier<Boolean> isDarkMode) {
        return (context, button, delta) -> {
            NinePatchTexture.draw(getBtnTexture(button, isDarkMode), context, button.method_46426(), button.method_46427(), button.width(), button.height());
        };
    }

    private static class_2960 getBtnTexture(ButtonComponent btn, Supplier<Boolean> isDarkMode) {
        var btnType = (btn.active() ? (btn.method_49606() ? "hovered" : "active") : "disabled");
        var themeType = isDarkMode.get() ? "dark" : "light";

        return AlloyForgery.id("theme/" + themeType + "/button/" + btnType);
    }

    public static <T> Component makeInputSlots(List<T> entries, int paddingInset, Supplier<Boolean> isDarkMode, Function<T, Component> slotBuilder, Predicate<T> isSlotDisabled) {
        return verticalFlow(Sizing.content(), Sizing.content())
            .<FlowLayout>configure(layout -> {
                var inputSlots = entries.stream()
                    .map(t -> verticalFlow(Sizing.content(), Sizing.content())
                        .child(slotBuilder.apply(t))
                        .padding(Insets.of(paddingInset))
                        .surface((context, component) -> {
                            var slotTexture = themedTextureID("input_slot_background.png", isDarkMode);

                            context.method_25290(class_10799.field_56883, slotTexture, component.x(), component.y(), isSlotDisabled.test(t) ? 18 : 0, 0,18, 18, 36, 18);
                        }))
                    .toList();

                var middleIndex = (int) Math.floor(inputSlots.size() / 2f);

                boolean onlySingleRow = inputSlots.size() <= 2;

                if (onlySingleRow) middleIndex = inputSlots.size();

                var topSlots = inputSlots.subList(0, middleIndex);

                // 42, 41
                layout.child(horizontalFlow(Sizing.content(), Sizing.content()).children(topSlots));

                if (!onlySingleRow) {
                    var bottomSlots = inputSlots.subList(middleIndex, inputSlots.size());

                    layout.child(horizontalFlow(Sizing.content(), Sizing.content()).children(bottomSlots));
                }

                layout.surface(
                    (context, component) -> context.drawRectOutline(component.x(), component.y(), component.width(), component.height(), getThemedValue(0xFF373737, 0xFF0B0B0B))
                );
            })
            .padding(Insets.of(1))
            .horizontalAlignment(HorizontalAlignment.CENTER);
    }
}
