package io.wispforest.alloyforgery.compat;

import io.wispforest.alloyforgery.AlloyForgery;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public class LegacyIdMappings {

    private static final Map<class_2960, class_2960> MAPPINGS = new HashMap<>();

    static {
        MAPPINGS.put(id("blackstone_forge_controller"), id("polished_blackstone_forge_controller"));
        MAPPINGS.put(id("brick_forge_controller"), id("bricks_forge_controller"));
        MAPPINGS.put(id("deepslate_forge_controller"), id("deepslate_bricks_forge_controller"));
        MAPPINGS.put(id("end_stone_forge_controller"), id("end_stone_bricks_forge_controller"));
        MAPPINGS.put(id("stone_brick_forge_controller"), id("stone_bricks_forge_controller"));
    }

    public static final String MOD_ID = "alloy_forgery";

    public static class_2960 remap(@Nullable class_2960 original) {
        if (original == null) return null;

        if (original.method_12836().equals(MOD_ID)) {
            original = class_2960.method_60655(AlloyForgery.MOD_ID, original.method_12832());
        }

        return MAPPINGS.getOrDefault(original, original);
    }

    private static class_2960 id(String path) {
        return class_2960.method_60655(AlloyForgery.MOD_ID, path);
    }
}
