package io.wispforest.alloyforgery.data;

import io.wispforest.owo.network.ClientAccess;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3503;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.resource.*;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.networking.AlloyForgeNetworking;
import java.util.*;
import java.util.stream.Collectors;

/**
 * Tag Loader used to load Recipe Based tags with the resolving
 * process being delayed till Data Pack load has ended
 */
public class RecipeTagLoader extends class_4080<Map<class_2960, List<class_3503.class_5145>>> {

    public static final class_2960 ID = AlloyForgery.id("recipe_tag");

    public static final RecipeTagLoader INSTANCE = new RecipeTagLoader();

    private RecipeTagLoader() {}

    private static final Map<class_2960, Set<class_2960>> RESOLVED_CLIENT_ENTRIES = new LinkedHashMap<>();
    private static final Map<class_2960, Set<class_2960>> RESOLVED_SERVER_ENTRIES = new LinkedHashMap<>();

    private boolean areEntriesResolved = true;
    private static final Map<class_2960, List<class_3503.class_5145>> RAW_TAG_DATA = new LinkedHashMap<>();

    private final DelayedTagGroupLoader<class_8786<class_1860<?>>> tagGroupLoader = new DelayedTagGroupLoader<>("tags/recipe");

    @Override
    protected Map<class_2960, List<class_3503.class_5145>> method_18789(class_3300 manager, class_3695 profiler) {
        return this.tagGroupLoader.method_33174(manager);
    }

    @Override
    protected void apply(Map<class_2960, List<class_3503.class_5145>> prepared, class_3300 manager, class_3695 profiler) {
        RAW_TAG_DATA.clear();

        RAW_TAG_DATA.putAll(prepared);
        areEntriesResolved = false;
    }

    //--

    /**
     * @param tag   Identifier for the given Tag
     * @param entry Recipe Entry to check
     * @return true if the tag exists and if the given entry exists within the Tag group
     */
    public static boolean isWithinTag(boolean isClient, class_2960 tag, class_8786<?> entry) {
        return isWithinTag(isClient, tag, entry.comp_1932().method_41185());
    }

    /**
     * @param tag      Identifier for the given Tag
     * @param recipeID Recipe identifier
     * @return true if the tag exists and if the given entry exists within the Tag group
     */
    public static boolean isWithinTag(boolean isClient, class_2960 tag, class_2960 recipeID) {
        var entries = (isClient ? RESOLVED_CLIENT_ENTRIES : RESOLVED_SERVER_ENTRIES);

        return entries.containsKey(tag) && entries.get(tag).contains(recipeID);
    }

    //--

    @ApiStatus.Internal
    public void sendPlayerPacketAfterDataLoad(class_3222 player) {
        resolveEntries(player.method_51469().method_8503());

        sendTagPacket(player);
    }

    @ApiStatus.Internal
    public void onServerStarted(MinecraftServer server) {
        resolveEntries(server);
    }

    private void resolveEntries(MinecraftServer server) {
        if (areEntriesResolved) return;

        var recipeManager = server.method_3772();

        Map<class_2960, List<class_8786<class_1860<?>>>> map = tagGroupLoader.setGetter(identifier -> {
                return Optional.ofNullable((class_8786<class_1860<?>>) recipeManager.method_8130(class_5321.method_29179(class_7924.field_52178, identifier)).orElse(null));
            })
            .method_18242(RAW_TAG_DATA);

        RESOLVED_SERVER_ENTRIES.clear();

        map.forEach((id, recipes) -> RESOLVED_SERVER_ENTRIES.put(id, recipes.stream().map(class_8786::comp_1932).map(class_5321::method_29177).collect(Collectors.toSet())));

        areEntriesResolved = true;
    }

    public void sendTagPacket(class_3222 player) {
        AlloyForgeNetworking.CHANNEL.serverHandle(player).send(RecipeTagLoader.TagPacket.of(RESOLVED_SERVER_ENTRIES));
    }

    // Packet that acts as a sync packet for the Recipe Based Tag Entries
    public record TagPacket(List<TagEntry> entries) {
        public static TagPacket of(Map<class_2960, Set<class_2960>> tagEntries) {
            return new TagPacket(tagEntries.entrySet().stream()
                .map(entry -> new TagEntry(entry.getKey(), List.copyOf(entry.getValue())))
                .toList());
        }

        public static void handlePacket(TagPacket packet, ClientAccess access) {
            RESOLVED_CLIENT_ENTRIES.clear();

            RESOLVED_CLIENT_ENTRIES.putAll(
                packet.entries.stream().collect(Collectors.toMap(TagEntry::id, e -> new HashSet<>(e.entries())))
            );
        }
    }

    public record TagEntry(class_2960 id, List<class_2960> entries) { }

    //--
}
