package io.wispforest.alloyforgery.fabric.data;

import io.wispforest.alloyforgery.data.providers.RecipeExporterConditionWrapper;
import io.wispforest.alloyforgery.data.providers.ResourceConditionHolder;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_8790;
import java.util.List;
import java.util.function.BiFunction;

public record FabricResourceConditionHolder(List<ResourceCondition> conditions) implements ResourceConditionHolder {

    public static RecipeExporterConditionWrapper createWrapper(BiFunction<class_8790, ResourceCondition[], class_8790> providerConditionWrapper) {
        return (recipeExporter, holder) -> {
            if (holder instanceof FabricResourceConditionHolder(java.util.List<ResourceCondition> conditions1)) {
                return providerConditionWrapper.apply(recipeExporter, conditions1.toArray(ResourceCondition[]::new));
            }

            return recipeExporter;
        };
    }

    @Override
    public <T extends class_1935> ResourceConditionHolder withTags(class_5321<class_2378<T>> key, class_6862<T>... tags) {
        this.conditions.add(net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions.tagsPopulated(key, tags));

        return this;
    }
}
