package io.wispforest.alloyforgery.forges;

import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public final class ForgeTier {

    public static final class_2960 DEFAULT_ID = AlloyForgery.id("default");
    public static final ForgeTier DEFAULT = new ForgeTier(DEFAULT_ID, 1, 1f, 48000);

    public static final Endec<ForgeTier> ENDEC = StructEndecBuilder.of(
        MinecraftEndecs.IDENTIFIER.fieldOf("id", ForgeTier::id),
        Endec.INT.fieldOf("tier", ForgeTier::value),
        Endec.FLOAT.fieldOf("speed_multiplier", ForgeTier::speedMultiplier),
        Endec.FLOAT.fieldOf("fuel_consumption_multiplier", ForgeTier::fuelConsumptionMultiplier),
        Endec.INT.fieldOf("fuel_capacity", ForgeTier::fuelCapacity),
        ForgeTier::new
    );

    public static final int BASE_MAX_SMELT_TIME = 200;

    private final class_2960 id;
    private final int value;
    private final float speedMultiplier;
    private final float fuelConsumptionMultiplier;
    private final int fuelCapacity;

    public ForgeTier(class_2960 id, int value, float speedMultiplier, float fuelConsumptionMultiplier, int fuelCapacity) {
        this.id = id;
        this.value = value;
        this.speedMultiplier = speedMultiplier;
        this.fuelConsumptionMultiplier = fuelConsumptionMultiplier;
        this.fuelCapacity = fuelCapacity;
    }

    public ForgeTier(class_2960 id, int value, float speedMultiplier, int fuelCapacity) {
        this(id, value, speedMultiplier, speedMultiplier, fuelCapacity);
    }

    @Deprecated(forRemoval = true)
    public ForgeTier(class_2960 id, int forgeTier, float speedMultiplier, int fuelCapacity, Optional<Integer> maxSmeltTime) {
        this(id, forgeTier, maxSmeltTime.map(integer -> integer / (float) BASE_MAX_SMELT_TIME).orElse(speedMultiplier), speedMultiplier, fuelCapacity);
    }

    public class_2960 id() {
        return id;
    }

    public int value() {
        return value;
    }

    public float speedMultiplier() {
        return speedMultiplier;
    }

    public float fuelConsumptionMultiplier() {
        return fuelConsumptionMultiplier;
    }

    public int fuelCapacity() {
        return fuelCapacity;
    }

    public int maxSmeltTime() {
        return (int) (BASE_MAX_SMELT_TIME / speedMultiplier);
    }

    public class_2561 name(boolean advancedName) {
        return class_2561.method_43469(id.method_42093(AlloyForgery.translationKey("tier." + (advancedName ? "advanced_" : "") + "name")), value);
    }

    public static class_2561 toName(boolean isClientSide, int value) {
        var tier = ForgeTierDataLoader.getForgeRegistry(isClientSide).getPrimaryTier(value);

        return  tier != null ? tier.name(true) : class_2561.method_43470(String.valueOf(value));
    }

    public void tooltip(boolean advancedName, Consumer<class_2561> tooltipCallback) {
        tooltipCallback.accept(AlloyForgery.tooltipTranslation("forge_tier", this.name(advancedName)).method_27692(class_124.field_1080));
        tooltipCallback.accept(AlloyForgery.tooltipTranslation("speed_multiplier", this.speedMultiplier()).method_27692(class_124.field_1080));
        tooltipCallback.accept(AlloyForgery.tooltipTranslation("fuel_consumption_multiplier", this.fuelConsumptionMultiplier()).method_27692(class_124.field_1080));
        tooltipCallback.accept(AlloyForgery.tooltipTranslation("fuel_capacity", this.fuelCapacity()).method_27692(class_124.field_1080));
    }

    @Override
    public String toString() {
        return "ForgeTier[" +
            "id: " + id + ", " +
            "value: " + value + ", " +
            "speedMultiplier: " + speedMultiplier + ", " +
            "fuelConsumptionMultiplier: " + fuelConsumptionMultiplier + ", " +
            "fuelCapacity: " + fuelCapacity +
            ']';
    }
}
