package io.wispforest.alloyforgery.recipe;

import ;
import Z;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import com.google.common.collect.Streams;
import com.google.gson.JsonSyntaxException;
import io.wispforest.alloyforgery.forges.ForgeTier;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.util.RecipeRemainderStorage;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import net.minecraft.class_10355;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3956;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9326;
import net.minecraft.class_9887;
import net.minecraft.item.*;
import net.minecraft.recipe.*;
import net.minecraft.registry.*;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.block.ForgeControllerBlockEntity;

import java.lang.reflect.Array;
import java.util.*;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class AlloyForgeRecipe implements class_1860<AlloyForgeRecipeInput> {

    private static final Map<class_1792, class_1799> GLOBAL_REMAINDERS = new HashMap<>();

    private static final List<Integer> INPUT_SLOT_INDICES = IntStream.rangeClosed(0, 9).boxed().toList();

    public static final Map<AlloyForgeRecipe, PendingRecipeData> PENDING_RECIPES = new HashMap<>();

    public final Optional<RawAlloyForgeRecipe> rawRecipeData;

    /**
     * Used for Recipes that were adapted to Alloy Forge Recipes instead of created from scratch.
     * Such serves as a holder for the original Identifier of the Recipe for Item Viewer Mods like REI and EMI
     */
    private Optional<class_2960> secondaryID = Optional.empty();

    private final Map<class_1856, Integer> inputs;
    private class_1799 output;

    private final int minForgeTier;
    private final int fuelPerTick;

    private ImmutableMap<OverrideRange, class_1799> tierOverrides;

    public AlloyForgeRecipe(Optional<RawAlloyForgeRecipe> rawRecipeData, Map<class_1856, Integer> inputs, class_1799 output, int minForgeTier, int fuelPerTick, Map<OverrideRange, class_1799> overrides) {
        this.rawRecipeData = rawRecipeData;

        this.inputs = inputs;
        this.output = output;
        this.minForgeTier = minForgeTier;
        this.fuelPerTick = fuelPerTick;

        this.tierOverrides = ImmutableMap.copyOf(overrides);
    }

    public AlloyForgeRecipe(Map<class_1856, Integer> inputs, class_1799 output, int minForgeTier, int fuelPerTick, Map<OverrideRange, class_1799> overrides, Optional<class_2960> secondaryID) {
        this(Optional.empty(), inputs, output, minForgeTier, fuelPerTick, overrides);

        this.secondaryID = secondaryID;
    }

    public Optional<class_2960> secondaryID() {
        return this.secondaryID;
    }

    public void finishRecipe(class_7871.class_7872 registryLookup, PendingRecipeData pendingData, Function<AlloyForgeRecipe, class_2960> lookup) {
        if (pendingData.defaultTag() != null) {
            final var itemEntryList = registryLookup.method_46751(class_7924.field_41197).method_46733(pendingData.defaultTag().method_15442());

            itemEntryList.ifPresentOrElse(registryEntries -> {
                this.output = registryEntries.method_40240(0).comp_349().method_7854();
                this.output.method_7939(pendingData.defaultTag().method_15441());
            }, () -> {
                throw new InvalidTagException("Default tag " + pendingData.defaultTag().method_15442().comp_327() + " of recipe " + lookup.apply(this) + " must not be empty");
            });
        }

        final var overrides = ImmutableMap.<OverrideRange, class_1799>builder();

        pendingData.unfinishedTierOverrides().forEach((range, override) -> {
            if (override.isCountOnly()) {
                class_1799 stack = this.output.method_7972();
                stack.method_7939(override.count());

                if (!override.components().method_57848()) {
                    stack.method_59692(override.components());
                }

                overrides.put(range, stack);
            } else {
                overrides.put(range, override.stack());
            }
        });

        this.tierOverrides = overrides.build();
    }

    public static void addRemainders(Map<class_1792, class_1799> remainders) {
        GLOBAL_REMAINDERS.putAll(remainders);
    }

    @Override
    public boolean method_8118() {
        return true;
    }

    @Override
    public boolean matches(AlloyForgeRecipeInput input, class_1937 world) {
        return tryBind(input) != null;
    }

    public Int2IntMap tryBind(AlloyForgeRecipeInput input) {
        var indices = new ConcurrentLinkedQueue<>(INPUT_SLOT_INDICES);
        var boundSlots = new Int2IntLinkedOpenHashMap();

        for (var ingredient : this.inputs.entrySet()) {
            int remaining = ingredient.getValue();

            for (int index : indices) {
                var stack = input.method_59984(index);

                if (ingredient.getKey().method_8093(stack)) {
                    boundSlots.put(index, Math.min(stack.method_7947(), remaining));
                    indices.remove(index);

                    remaining -= stack.method_7947();
                    if (remaining <= 0) break;
                }
            }

            if (remaining > 0) {
                return null;
            }
        }

        verification:
        for (int index : indices) {
            var stack = input.method_59984(index);
            if (stack.method_7960()) continue;

            for (var ingredient : this.inputs.keySet()) {
                if (ingredient.method_8093(stack)) {
                    continue verification;
                }
            }

            return null;
        }

        return boundSlots;
    }

    @SuppressWarnings("SuspiciousToArrayCall")
    @Nullable
    private class_9887 ingredientPlacement;

    @Override
    public class_9887 method_61671() {
        if (this.ingredientPlacement == null) {
            this.ingredientPlacement = class_9887.method_61683(
                    getIngredientsMap().keySet()
                            .stream()
                            .map(Optional::of)
                            .toList());
        }

        return this.ingredientPlacement;
    }

    public Map<class_1856, Integer> getIngredientsMap() {
        return inputs;
    }

    // Attempt to test if the passed inventory is a Controller to try and get the forgeTier
    // Better to use the getOutput though other means rather than this if not a controller
    @Override
    public class_1799 craft(AlloyForgeRecipeInput input, class_7225.class_7874 lookup) {
        return (input.inventory() instanceof ForgeControllerBlockEntity controller)
            ? getResult(controller.forgeTier().value())
            : getBaseResult();
    }

    public void consumeIngredients(AlloyForgeRecipeInput input) {
        var inventory = input.inventory();
        this.tryBind(input).forEach(inventory::method_5434);
    }

    @Nullable
    public static class_2371<class_1799> gatherRemainders(class_8786<AlloyForgeRecipe> recipeEntry, AlloyForgeRecipeInput input) {
        final var id = recipeEntry.comp_1932().method_29177();
        final var recipe = recipeEntry.comp_1933();
        final var remainders = class_2371.method_10213(input.method_59983(), class_1799.field_8037);
        //noinspection UnstableApiUsage
        final var owoRemainders = RecipeRemainderStorage.has(id) ? RecipeRemainderStorage.get(id) : Map.<class_1792, class_1799>of();

        if (owoRemainders.isEmpty() && GLOBAL_REMAINDERS.isEmpty()) return null;

        var setAnyRemainders = false;

        for (int i : recipe.tryBind(input).keySet()) {
            var item = input.method_59984(i).method_7909();

            if (!owoRemainders.isEmpty()) {
                if (!owoRemainders.containsKey(item)) continue;

                remainders.set(i, owoRemainders.get(item).method_7972());

                setAnyRemainders = true;
            } else if (GLOBAL_REMAINDERS.containsKey(item)) {
                remainders.set(i, GLOBAL_REMAINDERS.get(item).method_7972());

                setAnyRemainders = true;
            }
        }

        return setAnyRemainders ? remainders : null;
    }

    /**
     * Quickly copy the base output for a recipe, skips calculations from {@link #getResult(int)}
     */
    @ApiStatus.Internal
    public class_1799 getBaseResult() {
        return this.output.method_7972();
    }

    public class_1799 getResult(int forgeTier) {
        class_1799 stack = tierOverrides.getOrDefault(tierOverrides.keySet().stream()
                .filter(overrideRange -> overrideRange.test(forgeTier))
                .findAny()
                .orElse(null), output)
            .method_7972();

        if (stack.method_7909() == class_1802.field_8162) {
            int stackCount = stack.method_7947();

            stack = this.output.method_7972();

            stack.method_7939(stackCount);
        }

        return stack;
    }

    @Override
    public class_1865<? extends class_1860<AlloyForgeRecipeInput>> method_8119() {
        return AlloyForgeRecipeSerializer.INSTANCE;
    }

    @Override
    public class_3956<? extends class_1860<AlloyForgeRecipeInput>> method_17716() {
        return Type.INSTANCE;
    }

    @Override
    public class_10355 method_64668() {
        return null;
    }

    public int getMinForgeTier() {
        return minForgeTier;
    }

    public int getFuelPerTick() {
        return fuelPerTick;
    }

    public ImmutableMap<OverrideRange, class_1799> getTierOverrides() {
        return tierOverrides;
    }

    public static class Type implements class_3956<AlloyForgeRecipe> {
        private Type() {}

        public static final class_2960 ID = AlloyForgery.id("forging");
        public static final Type INSTANCE = new Type();
    }

    public record PendingRecipeData(@Nullable class_3545<class_6862<class_1792>, Integer> defaultTag, Map<OverrideRange, PendingOverride> unfinishedTierOverrides) { }

    public record PendingOverride(@Nullable class_1792 item, int count, class_9326 components) {
        public boolean isCountOnly() {
            return this.item == null;
        }

        public static PendingOverride onlyCount(int count) {
            return new PendingOverride(null, count, class_9326.field_49588);
        }

        public static PendingOverride ofItem(class_1792 item, int count) {
            return new PendingOverride(item, count, class_9326.field_49588);
        }

        public class_1799 stack() {
            var stack = new class_1799(item, count);

            stack.method_59692(components);

            return new class_1799(item, count);
        }
    }

    public static class InvalidTagException extends RuntimeException {
        public InvalidTagException(String message) {
            super(message);
        }
    }

    public record OverrideRange(int lowerBound, int upperBound) {

        public static Endec<OverrideRange> OVERRIDE_RANGE = StructEndecBuilder.of(
            Endec.INT.fieldOf("lowerBound", AlloyForgeRecipe.OverrideRange::lowerBound),
            Endec.INT.fieldOf("upperBound", AlloyForgeRecipe.OverrideRange::upperBound),
            AlloyForgeRecipe.OverrideRange::new
        );

        public OverrideRange(int lowerBound) {
            this(lowerBound, -1);
        }

        public boolean test(int value) {
            return value >= lowerBound && (upperBound == -1 || value <= upperBound);
        }

        public static AlloyForgeRecipe.OverrideRange fromString(String s) {
            AlloyForgeRecipe.OverrideRange overrideRange;

            if (s.matches("\\d+\\+")) {
                overrideRange = new AlloyForgeRecipe.OverrideRange(Integer.parseInt(s.substring(0, s.length() - 1)));
            } else if (s.matches("\\d+ to \\d+")) {
                overrideRange = new AlloyForgeRecipe.OverrideRange(Integer.parseInt(s.substring(0, s.indexOf(" "))), Integer.parseInt(s.substring(s.lastIndexOf(" ") + 1, s.length())));
            } else if (s.matches("\\d+")) {
                overrideRange = new AlloyForgeRecipe.OverrideRange(Integer.parseInt(s), Integer.parseInt(s));
            } else {
                throw new JsonSyntaxException("Invalid override range token: " + s);
            }

            return overrideRange;
        }

        public class_2561 toText(boolean isClientSide) {
            var lowerTierName = ForgeTier.toName(isClientSide, lowerBound);

            if (upperBound != lowerBound) {
                if (upperBound == -1) {
                    return AlloyForgery.tooltipTranslation("override_range.greater_or_equal_to", lowerTierName);
                } else {
                    var to = " to ".chars().mapToObj(value -> (char) value).toArray(Character[]::new);

                    var upperTierName = ForgeTier.toName(isClientSide, lowerBound);

                    return AlloyForgery.tooltipTranslation("override_range.range", lowerTierName, upperTierName);
                }
            } else {
                return AlloyForgery.tooltipTranslation("override_range.equal_to", lowerTierName);
            }
        }

        // Biograpgy:
        // - Proginator: glisco
        // - Reason: Used massive intellect to handcraft one of the methods of all time as an act of defence to all
        //   proper coding practices meaning it is ART, and it must be protected!
        //
        // Curator Notes:
        // - Noaaan: Any attempt to optimize this mess has been unilaterally denied
        // - Blodhgarm: With permission from proginator, adjustments to the code WAS made
        //
        // Any issues may be direct at the original author though the below Code:
        //
        // ██████████████████████████████████████████████████████
        // ██              ████  ██████  ████  ██              ██
        // ██  ██████████  ██    ██            ██  ██████████  ██
        // ██  ██      ██  ████      ████  ██████  ██      ██  ██
        // ██  ██      ██  ██    ██          ████  ██      ██  ██
        // ██  ██      ██  ██████  ██    ████  ██  ██      ██  ██
        // ██  ██████████  ██  ██  ██████    ████  ██████████  ██
        // ██              ██  ██  ██  ██  ██  ██              ██
        // ████████████████████████  ████  ██  ██████████████████
        // ██          ██          ████  ██████  ██  ██  ██  ████
        // ████      ██  ██████  ██  ██  ██████████  ██████  ████
        // ██  ██████  ██    ██  ██████      ██████████  ██    ██
        // ██        ██████          ████            ████████  ██
        // ██    ████  ██    ██  ██████  ██████        ██      ██
        // ██    ████  ██████          ██  ██  ████  ██  ██  ████
        // ██  ██  ██      ██  ██  ██        ██  ██      ██    ██
        // ██  ██    ██  ████  ██    ██████████████    ██████  ██
        // ██  ██  ██  ██  ██  ██        ██            ██  ██████
        // ██████████████████  ████  ██    ██  ██████    ████████
        // ██              ██  ██  ██████████  ██  ██  ██      ██
        // ██  ██████████  ████  ██  ████  ██  ██████    ████  ██
        // ██  ██      ██  ██  ██  ████                ██    ████
        // ██  ██      ██  ██  ██          ████    ██          ██
        // ██  ██      ██  ██      ██  ████████  ██████    ██  ██
        // ██  ██████████  ██  ██████████████  ████      ████  ██
        // ██              ██  ████████    ████                ██
        // ██████████████████████████████████████████████████████
        //
        @Override
        public String toString() {
            var outString = String.valueOf(lowerBound);
            var chars = outString.chars().mapToObj(value -> (char) value);

            if (upperBound != lowerBound) {
                if (upperBound == -1) {
                    chars = Stream.concat(chars, Stream.of('+'));
                } else {
                    var to = " to ".chars().mapToObj(value -> (char) value).toArray(Character[]::new);
                    chars = Stream.concat(chars, Arrays.stream(to));

                    var bound = String.valueOf(upperBound).chars().mapToObj(value -> (char) value).toArray(Character[]::new);
                    chars = Stream.concat(chars, Arrays.stream(bound));
                }
            }

            var output = new StringBuffer();
            chars.forEach(character -> output.append(character));

            return output.toString();
        }
    }
}
