package io.wispforest.alloyforgery.recipe;

import com.mojang.logging.LogUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import io.wispforest.alloyforgery.utils.EndecUtils;

import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9326;

public record OutputData(Integer count, class_9326 components, @Nullable class_1792 outputItem, @Nullable List<class_2960> items, @Nullable class_6862<class_1792> defaultTag) {

    public OutputData(Integer count, @Nullable class_1792 outputItem, @Nullable List<class_2960> items, @Nullable class_6862<class_1792> defaultTag) {
        this(count, class_9326.field_49588, outputItem, items, defaultTag);
    }

    private static final Logger LOGGER = LogUtils.getLogger();

    @Deprecated(forRemoval = true)
    private static final Endec<OutputData> OLD_FORMAT_ENDEC = StructEndecBuilder.of(
        Endec.INT.fieldOf("count", OutputData::count),
        MinecraftEndecs.ofRegistry(class_7923.field_41178).optionalFieldOf("id", OutputData::outputItem, () -> null),
        MinecraftEndecs.IDENTIFIER.listOf().optionalFieldOf("priority", OutputData::items, () -> null),
        MinecraftEndecs.unprefixedTagKey(class_7924.field_41197).optionalFieldOf("default", OutputData::defaultTag, () -> null),
        OutputData::new
    );

    private static final Endec<OutputData> NEW_FORMAT_ENDEC = StructEndecBuilder.of(
        Endec.INT.fieldOf("count", OutputData::count),
        EndecUtils.optionalFieldOf("components", CodecUtils.toEndec(class_9326.field_49589), OutputData::components, () -> class_9326.field_49588),
        MinecraftEndecs.ofRegistry(class_7923.field_41178).optionalFieldOf("item", OutputData::outputItem, () -> null),
        MinecraftEndecs.IDENTIFIER.listOf().optionalFieldOf("priority", OutputData::items, () -> null),
        MinecraftEndecs.unprefixedTagKey(class_7924.field_41197).optionalFieldOf("tag", OutputData::defaultTag, () -> null),
        OutputData::new
    );

    public static final Endec<OutputData> ENDEC = NEW_FORMAT_ENDEC.catchErrors((ctx, deserializer, e) -> {
        if (!(e instanceof InvalidOutputDataException)) throw new RuntimeException(e);

        var data = OLD_FORMAT_ENDEC.decode(ctx, deserializer);

        //LOGGER.warn("Deprecated Alloy Forgery Recipe keys were used when decoding the recipe! Please change all 'id' -> 'item' and 'default' -> 'tag'. ");

        return data;
    });

    public OutputData {
        if (items != null && defaultTag == null) {
            throw new InvalidOutputDataException("Priority-based recipes must declare a 'default' tag");
        } else if (outputItem == null && defaultTag == null) {
            throw new InvalidOutputDataException("No output for the given recipe was found!");
        }
    }

    public boolean prioritisedOutput() {
        return items != null;
    }

    public static class InvalidOutputDataException extends IllegalArgumentException {
        public InvalidOutputDataException(String s) {
            super(s);
        }
    }
}
