package io.wispforest.alloyforgery.utils;

import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.block.ForgeControllerBlockEntity;
import io.wispforest.alloyforgery.data.providers.ResourceConditionHolder;
import io.wispforest.alloyforgery.forges.ForgeDefinition;
import io.wispforest.alloyforgery.forges.ForgeRegistry;
import io.wispforest.alloyforgery.utils.data.EndecDataLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import net.minecraft.recipe.*;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.OptionalInt;
import java.util.ServiceLoader;
import java.util.stream.Stream;

public interface GeneralPlatformUtils {
    GeneralPlatformUtils INSTANCE = load(GeneralPlatformUtils.class);

    //--

    <T extends class_1703, D> class_3917<T> createScreenHandlerType(ExtendedFactory<T, D> factory, class_9139<? super class_9129, D> packetCodec);

    interface ExtendedFactory<T extends class_1703, D> {
        T create(int syncId, class_1661 inventory, D data);
    }

    //--

    <T extends class_2586> class_2591<T> createBlockEntityType(Factory<T> factory);

    void addToBlockEntity(class_2591<ForgeControllerBlockEntity> type, class_2248...blocks);

    @FunctionalInterface
    public interface Factory<T extends class_2586> {
        T create(class_2338 blockPos, class_2680 blockState);
    }

    //--

    boolean interactWithFluidStorage(ForgeControllerBlockEntity controller, class_1657 player, class_1268 hand);

    FluidStorage createStorage(ForgeControllerBlockEntity controller);

    //--

    <I extends class_9695, T extends class_1860<I>> Stream<class_8786<T>> getAllMatches(class_1863 manager, class_3956<T> type, I input, class_1937 world);

    <I extends class_9695, T extends class_1860<I>> Collection<class_8786<T>> getAllOfType(class_1863 manager, class_3956<T> type);

    class_1856 createStackIngredient(class_1799 stack);

    //--

    void registerLoader(class_2960 id, class_3264 packType, EndecDataLoader<?> loader, boolean requiresRegistries);

    //--

    ResourceConditionHolder createConditionsHolder();

    //--

    default OptionalInt openHandledScreen(class_1657 player, ForgeControllerBlockEntity blockEntity, @Nullable class_3908 factory) {
        return player.method_17355(factory);
    }

    //--

    private static <T> T load(Class<T> clazz) {
        final T loadedService = ServiceLoader.load(clazz)
                .findFirst()
                .orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));

        AlloyForgery.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);

        return loadedService;
    }

    //--

    void handleDefinitionEntry(ForgeRegistry.EntryHolder holder);
}
