package io.wispforest.alloyforgery.utils.data;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationContext;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.RegistriesAttribute;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import io.wispforest.alloyforgery.mixin.JsonDataLoaderAccessor;

import java.util.*;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7654;


// TODO: 1.21.4 ADJUSTMENTS SHOULD BE MADE TO USE LESS DIRECT CODE ANYWAYS
public abstract class EndecDataLoader<T> extends class_4309<T> {

    protected final String type;

    protected final class_2960 id;
    protected final Endec<T> endec;

    protected final Set<class_2960> dependencies;

    protected final SerializationContext context;

    protected final boolean requiresRegistries;

    private EndecDataLoader(class_2960 id, String type, Endec<T> endec, SerializationContext context, boolean requiresRegistries, Set<class_2960> value) {
        super(new DelayedRecursiveCodec<>(), class_7654.method_45114(type));

        this.id = id;
        this.type = type;
        this.endec = endec;
        this.context = context;
        this.requiresRegistries = requiresRegistries;
        this.dependencies = Collections.unmodifiableSet(value);

        setupCodec();
    }

    public static <T> EndecDataLoader.Builder<T> builder(String type, Endec<T> endec) {
        return new Builder<>(type, endec);
    }

    public static class Builder<T> {
        protected final String type;
        protected final Endec<T> endec;

        //--

        protected final Set<class_2960> dependencies = new HashSet<>();

        protected SerializationContext context = SerializationContext.empty();

        protected boolean requiresRegistries = false;

        Builder(String type, Endec<T> endec) {
            this.type = type;
            this.endec = endec;
        }

        public Builder<T> addDependencies(class_2960 ...dependencies) {
            return addDependencies(List.of(dependencies));
        }

        public Builder<T> addDependencies(Collection<class_2960> dependencies) {
            this.dependencies.addAll(dependencies);

            return this;
        }

        public Builder<T> requiresRegistries(boolean value) {
            this.requiresRegistries = value;

            return this;
        }

        public Builder<T> setContext(SerializationContext context) {
            this.context = context;

            return this;
        }

        public EndecDataLoader<T> create(class_2960 id, class_3264 packType, LoadedDataHandler<T> handler) {
            var loader = new EndecDataLoader<T>(id, this.type, this.endec, this.context, this.requiresRegistries, this.dependencies) {
                @Override
                protected void apply(Map<class_2960, T> prepared, class_3300 manager, class_3695 profiler) {
                    handler.handleData(prepared, manager, profiler);
                }
            };

            GeneralPlatformUtils.INSTANCE.registerLoader(id, packType, loader, this.requiresRegistries);

            return loader;
        }
    }

    public class_2960 getLoaderId() {
        return id;
    }

    public Set<class_2960> getDependencyIds() {
        return dependencies;
    }

    public boolean requiresRegistries() {
        return this.requiresRegistries;
    }

    protected void setupCodec() {
        ((DelayedRecursiveCodec<T>) ((JsonDataLoaderAccessor<T>) this).codec())
                .setup(this.endec.toString(), codec -> CodecUtils.toCodec(endec, this.getContext()));
    }

    @Nullable
    private class_7225.class_7874 registries = null;

    @Nullable
    private Function<class_11558, class_7225.class_7874> registryGetter = null;

    @Override
    public void prepareSharedState(class_11558 store) {
        if (requiresRegistries) {
            Objects.requireNonNull(registryGetter, "Can not get the needed context for the ManagedEndecDataLoader: " + this.getLoaderId());

            this.registries = registryGetter.apply(store);

            registryGetter = null;

            // Resets the given converted endec to grab new context with current registries
            setupCodec();
        }
    }

    @ApiStatus.Internal
    public EndecDataLoader<T> setRegistryGetter(Function<class_11558, class_7225.class_7874> registryGetter) {
        this.registryGetter = registryGetter;

        return this;
    }

    private SerializationContext getContext() {
        if (requiresRegistries) {
            Objects.requireNonNull(registries, "Can not build the needed context for the ManagedEndecDataLoader: " + this.getLoaderId());

            return this.context.withAttributes(RegistriesAttribute.fromCachedInfoGetter(new class_6903.class_9683(registries)));
        }

        return this.context;
    }

    @Override
    protected Map<class_2960, T> method_20731(class_3300 resourceManager, class_3695 profiler) {
        if (requiresRegistries && registries == null) {
            throw new IllegalStateException("Unable to prepare files as the given Registry access has not been setup on the server! [Id: " + this.getLoaderId() + "]");
        }

        var entries = super.method_20731(resourceManager, profiler);

        this.registries = null;

        return entries;
    }

    private static class DelayedRecursiveCodec<T> implements Codec<T> {
        private String name;
        private Supplier<Codec<T>> wrapped;

        public void setup(String name, Function<Codec<T>, Codec<T>> wrapped) {
            this.name = name;
            this.wrapped = Suppliers.memoize(() -> wrapped.apply(this));
        }

        @Override
        public <S> DataResult<Pair<T, S>> decode(final DynamicOps<S> ops, final S input) {
            return wrapped.get().decode(ops, input);
        }

        @Override
        public <S> DataResult<S> encode(final T input, final DynamicOps<S> ops, final S prefix) {
            return wrapped.get().encode(input, ops, prefix);
        }

        @Override
        public String toString() {
            return "RecursiveCodec[" + name + ']';
        }
    }

    public interface LoadedDataHandler<T> {
        void handleData(Map<class_2960, T> data, class_3300 manager, class_3695 profiler);
    }
}
