package io.wispforest.alloyforgery.block;

import com.mojang.serialization.MapCodec;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.particles.ClientParticles;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import net.minecraft.block.*;
import net.minecraft.block.entity.*;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1269.class_9860;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2960;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import net.minecraft.state.property.*;
import net.minecraft.util.*;
import org.jetbrains.annotations.Nullable;
import io.wispforest.alloyforgery.forges.ForgeFuelDataLoader;
import io.wispforest.alloyforgery.forges.ForgeFuelDataLoader.ForgeFuelDefinition;

public class ForgeControllerBlock extends class_2237 {

    public static final class_2746 LIT = class_2741.field_12548;
    public static final class_2754<class_2350> FACING = class_2741.field_12481;

    public final class_2960 forgeDefinitionId;

    public ForgeControllerBlock(class_2960 forgeDefinitionId, class_2251 settings) {
        super(settings);

        this.forgeDefinitionId = forgeDefinitionId;
        this.method_9590(this.method_9595().method_11664().method_11657(LIT, false));
    }

    public static ForgeControllerBlock of(class_2960 forgeDefinitionId, class_2960 blockId) {
        return new ForgeControllerBlock(forgeDefinitionId, class_2251.method_9630(class_2246.field_23869).method_63500(class_5321.method_29179(class_7924.field_41254, blockId)));
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return CodecUtils.toMapCodec(
            StructEndecBuilder.of(
                MinecraftEndecs.IDENTIFIER.fieldOf("forge_definition", s -> forgeDefinitionId),
                CodecUtils.toEndec(class_4970.class_2251.field_46532).fieldOf("properties", class_4970::method_54095),
                ForgeControllerBlock::new
            )
        );
    }

    @Override
    protected class_1269 method_55765(class_1799 playerStack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        var result = class_1269.field_5812;

        if (!world.field_9236) {
            final var fuelDefinition = ForgeFuelDataLoader.getFuelForItem(playerStack.method_7909());
            if (!(world.method_8321(pos) instanceof ForgeControllerBlockEntity controller)) {
                return class_1269.field_52423;
            }

            if (fuelDefinition.hasReturnType() && controller.canAddFuel(fuelDefinition.fuel())) {
                if (!player.method_31549().field_7477) {
                    player.method_31548().method_7398(new class_1799(fuelDefinition.returnType()));

                    var newStack = playerStack.method_7972();

                    newStack.method_7934(1);

                    result = class_1269.field_5812.method_61393(newStack);
                }
                controller.addFuel(fuelDefinition.fuel());
            } else if (!GeneralPlatformUtils.INSTANCE.interactWithFluidStorage(controller, player, hand)) {
                if (!controller.verifyMultiblock()) {
                    player.method_7353(AlloyForgery.translation("message", "invalid_multiblock").method_27692(class_124.field_1080), true);
                    return class_1269.field_5812;
                }

                final var screenHandlerFactory = state.method_26196(world, pos);
                if (screenHandlerFactory != null) {
                    GeneralPlatformUtils.INSTANCE.openHandledScreen(player, controller, screenHandlerFactory);
                }
            }
        }

        return result;
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() == newState.method_26204()) return;

        if (world.method_8321(pos) instanceof ForgeControllerBlockEntity forgeController) {
            class_1264.method_5451(world, pos, forgeController);
            class_1264.method_5449(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), forgeController.getFuelStack());
        }

        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    //@Environment(EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (!state.method_11654(LIT)) return;

        final class_2338 center = pos.method_10093(state.method_11654(FACING).method_10153());

        ClientParticles.setParticleCount(2);
        ClientParticles.setVelocity(new class_243(0, 0.1, 0));
        ClientParticles.spawnWithinBlock(class_2398.field_17430, world, center);

        ClientParticles.setParticleCount(5);
        ClientParticles.setVelocity(new class_243(0, 0.1, 0));
        ClientParticles.spawnWithinBlock(class_2398.field_11237, world, center);

        if (random.method_43058() > 0.65) {
            ClientParticles.setParticleCount(1);
            ClientParticles.setVelocity(new class_243(0, 0.01, 0));
            ClientParticles.spawnWithinBlock(class_2398.field_17430, world, center);
        }
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(LIT, FACING);
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? null : method_31618(type, ForgeControllerBlockEntity.FORGE_CONTROLLER_BLOCK_ENTITY, (world1, pos, state1, blockEntity) -> blockEntity.tick());
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return method_9564().method_11657(FACING, ctx.method_8042().method_10153());
    }

    @Override
    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return world.method_35230(pos, ForgeControllerBlockEntity.FORGE_CONTROLLER_BLOCK_ENTITY)
            .map(ForgeControllerBlockEntity::getCompartorOutput)
            .orElse(0);
    }

    @Override
    public boolean method_9498(class_2680 state) {
        return true;
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ForgeControllerBlockEntity(pos, state);
    }
}
