package io.wispforest.alloyforgery.data;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3497;
import net.minecraft.class_3503;
import net.minecraft.class_3545;
import net.minecraft.class_8523;

/**
 * Version of {@link class_3503} but with tweaks for delayed use and without entire tags being thrown out
 *
 * @param <T>
 */
public class DelayedTagGroupLoader<T> extends class_3503<T> {

    private static final Logger LOGGER = LogUtils.getLogger();

    private Function<class_2960, Optional<? extends T>> registryGetter = null;
    private final String dataType;

    public DelayedTagGroupLoader(String dataType) {
        super((id, required) -> Optional.empty(), dataType);

        this.dataType = dataType;
    }

    public DelayedTagGroupLoader<T> setGetter(Function<class_2960, Optional<? extends T>> registryGetter) {
        this.registryGetter = registryGetter;

        return this;
    }

    // Copy of vanilla but returns both the error list and the tag resolved to its best effort
    private class_3545<List<class_5145>, List<T>> resolveAll(class_3497.class_7474<T> valueGetter, List<class_3503.class_5145> entries) {
        SequencedSet<T> sequencedSet = new LinkedHashSet();
        List<class_3503.class_5145> list = new ArrayList();

        for (class_3503.class_5145 trackedEntry : entries) {
            if (!trackedEntry.comp_324().method_26790(valueGetter, sequencedSet::add)) {
                list.add(trackedEntry);
            }
        }

        return new class_3545<>(list, List.copyOf(sequencedSet));
    }

    // Copy to vanilla but checks if this versions registeryGetter is set and adjusts
    // error handling to log the error without throwing the entire tag out
    @Override
    public Map<class_2960, List<T>> method_18242(Map<class_2960, List<class_5145>> tags) {
        if (registryGetter == null)
            throw new RuntimeException("DelayedTagGroupLoader did not have the required registeryGetter set to resolve! [Type: " + this.dataType + "]");

        final Map<class_2960, List<T>> map = Maps.newHashMap();

        class_3497.class_7474<T> valueGetter = new class_3497.class_7474<>() {
            @Override
            public @Nullable T method_43948(class_2960 id, boolean required) {
                return registryGetter.apply(id).orElse(null);
            }

            @Nullable
            @Override
            public Collection<T> method_43949(class_2960 id) {
                return map.get(id);
            }
        };

        class_8523<class_2960, class_8522> dependencyTracker = new class_8523<>();

        tags.forEach((id, entries) -> dependencyTracker.method_51486(id, new class_8522(entries)));

        dependencyTracker.method_51487((id, dependencies) -> {
            var pair = this.resolveAll(valueGetter, dependencies.comp_1486());

            var missingReferences = pair.method_15442();

            if (!missingReferences.isEmpty()) {
                LOGGER.error(
                    "Couldn't load the given entries within tag {}: {}",
                    id,
                    missingReferences.stream().map(Objects::toString).collect(Collectors.joining(", "))
                );
            }

            map.put(id, pair.method_15441());
        });

        return map;
    }
}
