package io.wispforest.alloyforgery.fabric.utils;

import io.wispforest.alloyforgery.block.ForgeControllerBlockEntity;
import io.wispforest.alloyforgery.data.providers.ResourceConditionHolder;
import io.wispforest.alloyforgery.fabric.FluidHolderImpl;
import io.wispforest.alloyforgery.fabric.data.FabricResourceConditionHolder;
import io.wispforest.alloyforgery.fabric.data.IdentifiableResourceReloadListenerImpl;
import io.wispforest.alloyforgery.forges.ForgeRegistry;
import io.wispforest.alloyforgery.utils.FluidStorage;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import io.wispforest.alloyforgery.utils.data.EndecDataLoader;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorageUtil;
import net.fabricmc.fabric.impl.recipe.ingredient.builtin.ComponentsIngredient;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import net.minecraft.recipe.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;

public final class FabricGeneralPlatformUtils implements GeneralPlatformUtils {
    @Override
    public <T extends class_1703, D> class_3917<T> createScreenHandlerType(ExtendedFactory<T, D> factory, class_9139<? super class_9129, D> packetCodec) {
        return new ExtendedScreenHandlerType<>(factory::create, packetCodec);
    }

    //--

    @Override
    public <T extends class_2586> class_2591<T> createBlockEntityType(Factory<T> factory) {
        return FabricBlockEntityTypeBuilder.create(factory::create).build();
    }

    @Override
    public void addToBlockEntity(class_2591<ForgeControllerBlockEntity> type, class_2248... blocks) {
        for (var block : blocks) type.addSupportedBlock(block);
    }

    //--

    @Override
    public boolean interactWithFluidStorage(ForgeControllerBlockEntity controller, class_1657 player, class_1268 hand) {
        return FluidStorageUtil.interactWithFluidStorage(controller.<FluidHolderImpl>getFluidHolder(), player, hand);
    }

    @Override
    public FluidStorage createStorage(ForgeControllerBlockEntity controller) {
        return new FluidHolderImpl(controller::method_5431);
    }

    //--

    @Override
    public <I extends class_9695, T extends class_1860<I>> Stream<class_8786<T>> getAllMatches(class_1863 manager, class_3956<T> type, I input, class_1937 world) {
        return manager.getAllMatches(type, input, world);
    }

    @Override
    public <I extends class_9695, T extends class_1860<I>> Collection<class_8786<T>> getAllOfType(class_1863 manager, class_3956<T> type) {
        return manager.getAllOfType(type);
    }

    @Override
    public class_1856 createStackIngredient(class_1799 stack) {
        return new ComponentsIngredient(class_1856.method_8101(stack.method_7909()), stack.method_57380())
            .toVanilla();
    }

    //--

    @Override
    public void registerLoader(class_2960 id, class_3264 packType, EndecDataLoader<?> loader, boolean requiresRegistries) {
        var manager = ResourceManagerHelper.get(packType);
        var listenerWithId = new IdentifiableResourceReloadListenerImpl(id, loader, loader.getDependencyIds());

        if (class_3264.field_14190.equals(packType) && requiresRegistries) {
            manager.registerReloadListener(id, wrapperLookup -> {
                loader.setupOps(wrapperLookup);
                return listenerWithId;
            });
        } else {
            manager.registerReloadListener(listenerWithId);
        }
    }

    //--

    @Override
    public ResourceConditionHolder createConditionsHolder() {
        return new FabricResourceConditionHolder(new ArrayList<>());
    }

    //--

    @Override
    public void handleDefinitionEntry(ForgeRegistry.EntryHolder holder) {
        holder.registerBlock();
        holder.registerItem();
    }
}
