package io.wispforest.alloyforgery.networking;

import io.wispforest.owo.network.ClientAccess;
import io.wispforest.alloyforgery.forges.ForgeTier;
import io.wispforest.alloyforgery.forges.ForgeTierDataLoader;
import java.util.Map;
import net.minecraft.class_2960;

public record TierDataSync(Map<class_2960, ForgeTier> idToForgeTier, Map<class_2960, class_2960> forgeDefinitionToTier) {

    //@Environment(EnvType.CLIENT)
    public static void handlePacket(TierDataSync packet, ClientAccess access) {
        ForgeTierDataLoader.getForgeRegistry(true)
            .setTierData(packet.idToForgeTier(), packet.forgeDefinitionToTier());
    }
}
