package io.wispforest.alloyforgery.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.JsonOps;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import io.wispforest.alloyforgery.utils.LoaderPlatformUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import org.apache.commons.lang3.mutable.MutableInt;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.utils.EndecUtils;

import java.util.*;
import java.util.Map.Entry;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import net.minecraft.class_9326;

public record RawAlloyForgeRecipe(Map<class_1856, Integer> inputs, OutputData outputData,
                                  int minForgeTier, int requiredFuel,
                                  Map<AlloyForgeRecipe.OverrideRange, AlloyForgeRecipe.PendingOverride> overrideData) {

    public static Endec<Map<class_1856, Integer>> INPUTS = CountedIngredient.ENDEC.listOf().xmap(list -> {
        var unprocessedData = new Object2ObjectLinkedOpenHashMap<class_1856, MutableInt>();

        for (CountedIngredient countedIngredient : list) {
            var ingredient = countedIngredient.ingredient();

            if (unprocessedData.containsKey(ingredient) && (AlloyForgery.CONFIG.strictRecipeChecks() || LoaderPlatformUtils.INSTANCE.isDevelopmentEnvironment())) {
                var jsonData = class_1856.field_46095.encodeStart(JsonOps.INSTANCE, ingredient)
                    .result()
                    .map(JsonElement::toString)
                    .orElse("Error Unknown");

                throw new IllegalStateException("Duplicate Ingredient Entry! Merge all ingredients of [" + jsonData + "] into a single entry and add a count!");
            }

            unprocessedData.computeIfAbsent(ingredient, key -> new MutableInt(0))
                .add(countedIngredient.count());
        }

        var data = new LinkedHashMap<class_1856, Integer>();

        unprocessedData.forEach((ingredient, mutableInt) -> data.put(ingredient, mutableInt.getValue()));

        return data;
    }, map -> {
        return map.entrySet().stream()
            .map(entry -> new CountedIngredient(entry.getKey(), entry.getValue())).toList();
    });

    public static Endec<AlloyForgeRecipe.PendingOverride> PENDING_OVERRIDE = StructEndecBuilder.of(
        MinecraftEndecs.ofRegistry(class_7923.field_41178).optionalFieldOf("item", AlloyForgeRecipe.PendingOverride::item, () -> null),
        MinecraftEndecs.ofRegistry(class_7923.field_41178).optionalFieldOf("id", orderride -> null, () -> null), //TODO: REMOVE LATER
        Endec.INT.fieldOf("count", AlloyForgeRecipe.PendingOverride::count),
        EndecUtils.optionalFieldOf("components", CodecUtils.toEndec(class_9326.field_49589), AlloyForgeRecipe.PendingOverride::components, () -> class_9326.field_49588),
        (item, item2, count, components) -> {
            if (item == null) item = item2;

            return new AlloyForgeRecipe.PendingOverride(item, count, components);
        }
    );

    public static StructEndec<RawAlloyForgeRecipe> ENDEC = StructEndecBuilder.of(
        INPUTS.validate(ingredientToCount -> {
            if (ingredientToCount.isEmpty()) {
                throw new JsonSyntaxException("Inputs cannot be empty");
            } else if (ingredientToCount.keySet().size() > 10) {
                throw new JsonSyntaxException("Recipe has more than 10 distinct input ingredients");
            } else if (ingredientToCount.values().stream().mapToInt(integer -> integer).sum() > (10 * 64)) {
                throw new JsonSyntaxException("Recipe exceeded maximum input item count of " + (10 * 64));
            }
        }).fieldOf("inputs", RawAlloyForgeRecipe::inputs),
        OutputData.ENDEC.fieldOf("output", RawAlloyForgeRecipe::outputData),
        Endec.INT.fieldOf("min_forge_tier", RawAlloyForgeRecipe::minForgeTier),
        Endec.INT.fieldOf("fuel_per_tick", RawAlloyForgeRecipe::requiredFuel),
        PENDING_OVERRIDE.mapOf().xmap(rawData -> {
            Map<AlloyForgeRecipe.OverrideRange, AlloyForgeRecipe.PendingOverride> data = new LinkedHashMap<>();

            rawData.forEach((s, pendingOverride) -> data.put(AlloyForgeRecipe.OverrideRange.fromString(s), pendingOverride));

            return data;
        }, data -> {
            Map<String, AlloyForgeRecipe.PendingOverride> rawData = new LinkedHashMap<>();

            data.forEach((range, pendingOverride) -> rawData.put(range.toString(), pendingOverride));

            return rawData;
        }).optionalFieldOf("overrides", RawAlloyForgeRecipe::overrideData, HashMap::new),
        RawAlloyForgeRecipe::new
    );

    public class_3545<class_1799, ImmutableMap<AlloyForgeRecipe.OverrideRange, class_1799>> finalOutputData(Map<AlloyForgeRecipe.OverrideRange, AlloyForgeRecipe.PendingOverride> overridesBuilder) {
        if (outputData.outputItem() == null) return new class_3545<>(class_1799.field_8037, ImmutableMap.of());

        final var builder = ImmutableMap.<AlloyForgeRecipe.OverrideRange, class_1799>builder();

        final var outputStack = new class_1799(outputData.outputItem(), outputData.count());

        for (var entry : overridesBuilder.entrySet()) {
            class_1799 stack;

            if (entry.getValue().isCountOnly()) {
                stack = outputStack.method_7972();
                stack.method_7939(entry.getValue().count());
            } else {
                stack = entry.getValue().stack();
            }

            if (!entry.getValue().components().method_57848()) {
                stack.method_59692(entry.getValue().components());
            }

            builder.put(entry.getKey(), stack);
        }

        return new class_3545<>(outputStack, builder.build());
    }

    public AlloyForgeRecipe generateRecipe() {
        return generateRecipe(false);
    }

    public AlloyForgeRecipe generateRecipe(boolean isDataGenerated) {
        var outputData = this.finalOutputData(this.overrideData);

        final var recipe = new AlloyForgeRecipe(Optional.of(this), this.inputs, outputData.method_15442(), minForgeTier, requiredFuel, outputData.method_15441());

        if (!isDataGenerated && this.outputData.prioritisedOutput()) {
            AlloyForgeRecipe.PENDING_RECIPES.put(recipe, new AlloyForgeRecipe.PendingRecipeData(new class_3545<>(this.outputData.defaultTag(), this.outputData.count()), this.overrideData));
        }

        return recipe;
    }
}
