package io.wispforest.alloyforgery.utils;

import Z;
import com.google.common.collect.*;
import com.mojang.logging.LogUtils;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_10286;
import net.minecraft.class_10352;
import net.minecraft.class_10363;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.recipe.*;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import io.wispforest.alloyforgery.mixin.PreparedRecipesAccessor;
import io.wispforest.alloyforgery.mixin.ServerRecipeManagerAccessor;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

/**
 * Helper class to safety allow for injecting recipes into the Recipe Manager <b>without
 * overriding or modifying existing Recipes. </b>
 * <p/>
 * Primarily used to either add compatibility for existing recipes by converting to another form
 * or adding new recipes.
 */
public final class RecipeInjector {

    private static final Logger LOGGER = LogUtils.getLogger();

    /**
     * Event called on `ServerLifecycleEvents#SERVER_STARTED` or {@link DataPackEvents#BEFORE_SYNC} which adds
     * new recipes to the RecipeManager before sync to Players
     */
    public static final Event<AddRecipes> ADD_RECIPES = EventFactory.createArrayBacked(AddRecipes.class, addRecipes -> (instance) -> {
        for (AddRecipes addRecipe : addRecipes) {
            addRecipe.addRecipes(instance);
        }
    });

    private final class_1863 manager;
    private final class_1937 world;

    private final Multimap<class_3956<?>, class_8786<?>> recipes = HashMultimap.create();
    private final Map<class_2960, class_8786<?>> recipesById = new HashMap<>();

    public RecipeInjector(class_1863 manager, class_1937 world) {
        this.manager = manager;
        this.world = world;
    }

    /**
     * Attempts to register a given recipe for addition to the recipe manager if
     * 1. Such recipe has a registered {@link class_3956}
     * 2. Such is found to not have an existing Identifier within {@link class_10286}
     *
     * @param recipe The Recipe
     * @param <T>    Type of the given Recipe
     */
    public <R extends class_1860<T>, T extends class_9695> void addRecipe(class_2960 id, R recipe) {
        if (class_7923.field_41188.method_10221(recipe.method_17716()) == null) {
            throw new IllegalStateException("Unable to add Recipe for a RecipeType not registered!");
        }

        var type = (class_3956<R>) recipe.method_17716();

        var bl = getAllOfType(type)
            .stream()
            .anyMatch(recipeEntry -> id.equals(recipeEntry.comp_1932()));

        if (bl) {
            LOGGER.error("[RecipeInjector]: Unable to add a given recipe due to being the same Identifier with the given Type. [ID: {}]", id);

            return;
        }

        var recipeEntry = new class_8786<>(class_5321.method_29179(class_7924.field_52178, id), recipe);

        recipes.put(recipe.method_17716(), recipeEntry);
        recipesById.put(id, recipeEntry);
    }

    public <I extends class_9695, T extends class_1860<I>> Stream<class_8786<T>> getAllMatches(class_3956<T> type, I input, class_1937 world) {
        return GeneralPlatformUtils.INSTANCE.getAllMatches(this.manager, type, input, world);
    }

    /**
     * @return the collection of recipe entries of given type
     */
    public <I extends class_9695, T extends class_1860<I>> Collection<class_8786<T>> getAllOfType(class_3956<T> type) {
        return GeneralPlatformUtils.INSTANCE.getAllOfType(this.manager, type);
    }

    /**
     * @return The current instance of the {@link class_10286}
     */
    public class_1863 manager() {
        return this.manager;
    }

    public class_7225.class_7874 lookup() {
        return ((ServerRecipeManagerAccessor) this.manager).af$getRegistryLookup();
    }

    public List<class_1799> getStacks(class_1856 ingredient) {
        var ctx = class_10363.method_65008(this.world);

        return ingredient.method_64673().method_64738(ctx);
    }

    /**
     * Primary Event for adding new Recipes
     */
    public interface AddRecipes {
        void addRecipes(RecipeInjector instance);
    }

    //--

    public static void injectRecipes(MinecraftServer server) {
        var manager = server.method_3772();
        var injector = new RecipeInjector(server.method_3772(), server.method_3847(class_1937.field_25179));

        ADD_RECIPES.invoker().addRecipes(injector);

        var preparedRecipesAccessor = (PreparedRecipesAccessor) ((ServerRecipeManagerAccessor) manager).af$preparedRecipes();

        injector.recipes.putAll(preparedRecipesAccessor.af$getRecipes());
        injector.recipesById.putAll(preparedRecipesAccessor.af$getRecipesById());

        preparedRecipesAccessor.af$setRecipes(ImmutableMultimap.copyOf(injector.recipes));
        preparedRecipesAccessor.af$setRecipesById(ImmutableMap.copyOf(injector.recipesById));

        injector.recipes.clear();
        injector.recipesById.clear();
    }
}
