/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.data;

import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.data.DelayedTagGroupLoader;
import io.wispforest.alloyforgery.networking.AlloyForgeNetworking;
import io.wispforest.owo.network.ClientAccess;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3503;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

public class RecipeTagLoader
extends class_4080<Map<class_2960, List<class_3503.class_5145>>> {
    public static final class_2960 ID = AlloyForgery.id("recipe_tag");
    public static final RecipeTagLoader INSTANCE = new RecipeTagLoader();
    private static final Map<class_2960, Set<class_2960>> RESOLVED_CLIENT_ENTRIES = new LinkedHashMap<class_2960, Set<class_2960>>();
    private static final Map<class_2960, Set<class_2960>> RESOLVED_SERVER_ENTRIES = new LinkedHashMap<class_2960, Set<class_2960>>();
    private boolean areEntriesResolved = true;
    private static final Map<class_2960, List<class_3503.class_5145>> RAW_TAG_DATA = new LinkedHashMap<class_2960, List<class_3503.class_5145>>();
    private final DelayedTagGroupLoader<class_8786<class_1860<?>>> tagGroupLoader = new DelayedTagGroupLoader("tags/recipe");

    private RecipeTagLoader() {
    }

    protected Map<class_2960, List<class_3503.class_5145>> prepare(class_3300 manager, class_3695 profiler) {
        return this.tagGroupLoader.method_33174(manager);
    }

    protected void apply(Map<class_2960, List<class_3503.class_5145>> prepared, class_3300 manager, class_3695 profiler) {
        RAW_TAG_DATA.clear();
        RAW_TAG_DATA.putAll(prepared);
        this.areEntriesResolved = false;
    }

    public static boolean isWithinTag(boolean isClient, class_2960 tag, class_8786<?> entry) {
        return RecipeTagLoader.isWithinTag(isClient, tag, entry.comp_1932().method_41185());
    }

    public static boolean isWithinTag(boolean isClient, class_2960 tag, class_2960 recipeID) {
        Map<class_2960, Set<class_2960>> entries = isClient ? RESOLVED_CLIENT_ENTRIES : RESOLVED_SERVER_ENTRIES;
        return entries.containsKey(tag) && entries.get(tag).contains(recipeID);
    }

    @ApiStatus.Internal
    public void sendPlayerPacketAfterDataLoad(class_3222 player) {
        this.resolveEntries(player.field_13995);
        this.sendTagPacket(player);
    }

    @ApiStatus.Internal
    public void onServerStarted(MinecraftServer server) {
        this.resolveEntries(server);
    }

    private void resolveEntries(MinecraftServer server) {
        if (this.areEntriesResolved) {
            return;
        }
        class_1863 recipeManager = server.method_3772();
        Map map = this.tagGroupLoader.setGetter(identifier -> Optional.ofNullable(recipeManager.method_8130(class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)identifier)).orElse(null))).method_18242(RAW_TAG_DATA);
        RESOLVED_SERVER_ENTRIES.clear();
        map.forEach((id, recipes) -> RESOLVED_SERVER_ENTRIES.put((class_2960)id, recipes.stream().map(class_8786::comp_1932).map(class_5321::method_29177).collect(Collectors.toSet())));
        this.areEntriesResolved = true;
    }

    public void sendTagPacket(class_3222 player) {
        AlloyForgeNetworking.CHANNEL.serverHandle((class_1657)player).send((Record)TagPacket.of(RESOLVED_SERVER_ENTRIES));
    }

    public record TagPacket(List<TagEntry> entries) {
        public static TagPacket of(Map<class_2960, Set<class_2960>> tagEntries) {
            return new TagPacket(tagEntries.entrySet().stream().map(entry -> new TagEntry((class_2960)entry.getKey(), List.copyOf((Collection)entry.getValue()))).toList());
        }

        public static void handlePacket(TagPacket packet, ClientAccess access) {
            RESOLVED_CLIENT_ENTRIES.clear();
            RESOLVED_CLIENT_ENTRIES.putAll(packet.entries.stream().collect(Collectors.toMap(TagEntry::id, e -> new HashSet<class_2960>(e.entries()))));
        }
    }

    public record TagEntry(class_2960 id, List<class_2960> entries) {
    }
}

