/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.block;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.wispforest.alloyforgery.block.ForgeControllerBlockEntity;
import io.wispforest.alloyforgery.forges.ForgeFuelDataLoader;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.particles.ClientParticles;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ForgeControllerBlock
extends BaseEntityBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public final ResourceLocation forgeDefinitionId;

    public ForgeControllerBlock(ResourceLocation forgeDefinitionId, BlockBehaviour.Properties settings) {
        super(settings);
        this.forgeDefinitionId = forgeDefinitionId;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public static ForgeControllerBlock of(ResourceLocation forgeDefinitionId, ResourceLocation blockId) {
        return new ForgeControllerBlock(forgeDefinitionId, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)blockId)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CodecUtils.toMapCodec((StructEndec)StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.fieldOf("forge_definition", s -> this.forgeDefinitionId), (StructField)CodecUtils.toEndec((Codec)BlockBehaviour.Properties.CODEC).fieldOf("properties", BlockBehaviour::properties), ForgeControllerBlock::new));
    }

    protected InteractionResult useItemOn(ItemStack playerStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult.Success result = InteractionResult.SUCCESS;
        if (!world.isClientSide()) {
            ForgeFuelDataLoader.ForgeFuelDefinition fuelDefinition = ForgeFuelDataLoader.getFuelForItem(playerStack.getItem());
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (!(blockEntity instanceof ForgeControllerBlockEntity)) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            ForgeControllerBlockEntity controller = (ForgeControllerBlockEntity)blockEntity;
            if (fuelDefinition.hasReturnType() && controller.canAddFuel(fuelDefinition.fuel())) {
                if (!player.getAbilities().instabuild) {
                    player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)fuelDefinition.returnType()));
                    ItemStack newStack = playerStack.copy();
                    newStack.shrink(1);
                    result = InteractionResult.SUCCESS.heldItemTransformedTo(newStack);
                }
                controller.addFuel(fuelDefinition.fuel());
            } else if (!GeneralPlatformUtils.INSTANCE.interactWithFluidStorage(controller, player, hand)) {
                if (!controller.verifyMultiblock()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.alloy_forgery.invalid_multiblock").withStyle(ChatFormatting.GRAY), true);
                    return InteractionResult.SUCCESS;
                }
                MenuProvider screenHandlerFactory = state.getMenuProvider(world, pos);
                if (screenHandlerFactory != null) {
                    GeneralPlatformUtils.INSTANCE.openHandledScreen(player, controller, screenHandlerFactory);
                }
            }
        }
        return result;
    }

    protected void affectNeighborsAfterRemoval(BlockState state, ServerLevel world, BlockPos pos, boolean moved) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof ForgeControllerBlockEntity) {
            ForgeControllerBlockEntity forgeController = (ForgeControllerBlockEntity)blockEntity;
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)forgeController);
            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)forgeController.getFuelStack());
        }
        super.affectNeighborsAfterRemoval(state, world, pos, moved);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return;
        }
        BlockPos center = pos.relative(((Direction)state.getValue(FACING)).getOpposite());
        ClientParticles.setParticleCount((int)2);
        ClientParticles.setVelocity((Vec3)new Vec3(0.0, 0.1, 0.0));
        ClientParticles.spawnWithinBlock((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (Level)world, (BlockPos)center);
        ClientParticles.setParticleCount((int)5);
        ClientParticles.setVelocity((Vec3)new Vec3(0.0, 0.1, 0.0));
        ClientParticles.spawnWithinBlock((ParticleOptions)ParticleTypes.LARGE_SMOKE, (Level)world, (BlockPos)center);
        if (random.nextDouble() > 0.65) {
            ClientParticles.setParticleCount((int)1);
            ClientParticles.setVelocity((Vec3)new Vec3(0.0, 0.01, 0.0));
            ClientParticles.spawnWithinBlock((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (Level)world, (BlockPos)center);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide() ? null : ForgeControllerBlock.createTickerHelper(type, ForgeControllerBlockEntity.FORGE_CONTROLLER_BLOCK_ENTITY, (world1, pos, state1, blockEntity) -> blockEntity.tick());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos, Direction direction) {
        return world.getBlockEntity(pos, ForgeControllerBlockEntity.FORGE_CONTROLLER_BLOCK_ENTITY).map(ForgeControllerBlockEntity::getCompartorOutput).orElse(0);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ForgeControllerBlockEntity(pos, state);
    }
}

