/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.block;

import com.google.common.collect.ImmutableList;
import io.wispforest.alloyforgery.AlloyForgeScreenHandler;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.block.ForgeControllerBlock;
import io.wispforest.alloyforgery.block.ItemStackComparisonUtil;
import io.wispforest.alloyforgery.client.BlockEntityLocation;
import io.wispforest.alloyforgery.forges.ForgeDefinition;
import io.wispforest.alloyforgery.forges.ForgeFuelDataLoader;
import io.wispforest.alloyforgery.forges.ForgeRegistry;
import io.wispforest.alloyforgery.forges.ForgeTier;
import io.wispforest.alloyforgery.forges.ForgeTierDataLoader;
import io.wispforest.alloyforgery.mixin.HopperBlockEntityAccessor;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipe;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipeInput;
import io.wispforest.alloyforgery.utils.ExtObservable;
import io.wispforest.alloyforgery.utils.FluidStorage;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import io.wispforest.owo.ops.ItemOps;
import io.wispforest.owo.util.ImplementedInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ForgeControllerBlockEntity
extends BlockEntity
implements ImplementedInventory,
WorldlyContainer,
MenuProvider {
    private static final int[] DOWN_SLOTS = new int[]{10, 11};
    private static final Integer[] RIGHT_SLOTS = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final int[] LEFT_SLOTS = new int[]{11};
    public static final int INVENTORY_SIZE = 12;
    public static BlockEntityType<ForgeControllerBlockEntity> FORGE_CONTROLLER_BLOCK_ENTITY;
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)12, (Object)ItemStack.EMPTY);
    public final ExtObservable<Set<Integer>> disabledSlots = ExtObservable.of(new HashSet());
    private final NonNullList<ItemStack> previousItems = NonNullList.create();
    private boolean checkForRecipes = true;
    private Optional<RecipeHolder<AlloyForgeRecipe>> recipeCache = Optional.empty();
    public final ExtObservable<Integer> requiredTierToCraft = ExtObservable.of(-1);
    private final FluidStorage fluidHolder = GeneralPlatformUtils.INSTANCE.createStorage(this);
    private final ResourceLocation forgeDefinitionId;
    private final ImmutableList<BlockPos> multiblockPositions;
    private final Direction facing;
    private float fuel;
    private int currentSmeltTime;
    public final ExtObservable<Integer> smeltProgress = ExtObservable.of(0);
    public final ExtObservable<Integer> fuelProgress = ExtObservable.of(0);
    public final ExtObservable<Integer> lavaProgress = ExtObservable.of(0);

    public ForgeControllerBlockEntity(BlockPos pos, BlockState state) {
        super(FORGE_CONTROLLER_BLOCK_ENTITY, pos, state);
        this.forgeDefinitionId = ((ForgeControllerBlock)state.getBlock()).forgeDefinitionId;
        this.facing = (Direction)state.getValue(ForgeControllerBlock.FACING);
        this.multiblockPositions = ForgeControllerBlockEntity.generateMultiblockPositions(pos.immutable(), (Direction)state.getValue(ForgeControllerBlock.FACING));
    }

    public ForgeTier forgeTier() {
        if (this.level == null) {
            return ForgeTier.DEFAULT;
        }
        ForgeTier tier = ForgeTierDataLoader.getForgeRegistry(this.level.isClientSide()).getBoundForgeTier(this.forgeDefinitionId);
        if (tier == null) {
            return ForgeTier.DEFAULT;
        }
        return tier;
    }

    public BlockEntityLocation getExtraScreenData(ServerPlayer player) {
        return BlockEntityLocation.of(this);
    }

    protected void loadAdditional(ValueInput view) {
        ContainerHelper.loadAllItems((ValueInput)view, this.items);
        this.currentSmeltTime = view.getIntOr("CurrentSmeltTime", 0);
        this.fuel = view.getIntOr("Fuel", 0);
        ValueInput fluidData = view.childOrEmpty("FuelFluidInput");
        this.fluidHolder.readData(fluidData);
    }

    protected void saveAdditional(ValueOutput view) {
        ContainerHelper.saveAllItems((ValueOutput)view, this.items);
        view.putInt("Fuel", Math.round(this.fuel));
        view.putInt("CurrentSmeltTime", this.currentSmeltTime);
        ValueOutput fluidNbt = view.child("FuelFluidInput");
        this.fluidHolder.writeData(fluidNbt);
    }

    public <F extends FluidStorage> F getFluidHolder() {
        return (F)this.fluidHolder;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public ItemStack getFuelStack() {
        return this.getItem(11);
    }

    public boolean canAddFuel(int fuel) {
        return this.fuel + (float)fuel <= (float)this.forgeTier().fuelCapacity();
    }

    public void addFuel(int fuel) {
        this.fuel += (float)fuel;
    }

    public int getSmeltProgress() {
        return (Integer)this.smeltProgress.get();
    }

    public int getCurrentSmeltTime() {
        return this.currentSmeltTime;
    }

    public ForgeDefinition getForgeDefinition() {
        return ForgeRegistry.getForgeDefinition(this.forgeDefinitionId).orElseThrow(() -> new IllegalArgumentException("Unable to locate the given definition as its not registered! [Id: " + String.valueOf(this.forgeDefinitionId) + "]"));
    }

    public void disableSlot(int index) {
        ((Set)this.disabledSlots.get()).add(index);
        this.disabledSlots.markDirty();
    }

    public void enableSlot(int index) {
        ((Set)this.disabledSlots.get()).remove(index);
        this.disabledSlots.markDirty();
    }

    public int getCompartorOutput() {
        return this.getCurrentSmeltTime() != 0 ? Math.max(1, Math.round((float)this.getSmeltProgress() * 0.46875f)) : 0;
    }

    public void setChanged() {
        if (ItemStackComparisonUtil.itemsChanged(this.items, this.previousItems)) {
            this.previousItems.clear();
            this.previousItems.addAll(this.items.stream().map(ItemStack::copy).toList());
            this.checkForRecipes = true;
        }
        super.setChanged();
    }

    public void setItem(int slot, ItemStack stack) {
        super.setItem(slot, stack);
        this.setChanged();
    }

    public void tick() {
        Object fuelStack;
        ForgeFuelDataLoader.ForgeFuelDefinition fuelDefinition;
        this.smeltProgress.set(Math.round((float)this.currentSmeltTime / (float)this.forgeTier().maxSmeltTime() * 19.0f));
        this.fuelProgress.set(Math.round(this.fuel / (float)this.forgeTier().fuelCapacity() * 48.0f));
        this.lavaProgress.set(Math.round(this.fluidHolder.fullnessAmount() * 50.0f));
        this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
        if (!this.verifyMultiblock()) {
            this.currentSmeltTime = 0;
            BlockState currentState = this.level.getBlockState(this.worldPosition);
            if (((Boolean)currentState.getValue((Property)ForgeControllerBlock.LIT)).booleanValue()) {
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)currentState.setValue((Property)ForgeControllerBlock.LIT, (Comparable)Boolean.valueOf(false)));
            }
            return;
        }
        if (!this.getFuelStack().isEmpty() && (fuelDefinition = ForgeFuelDataLoader.getFuelForItem((fuelStack = this.getFuelStack()).getItem())) != ForgeFuelDataLoader.ForgeFuelDefinition.EMPTY && this.canAddFuel(fuelDefinition.fuel())) {
            this.getFuelStack().shrink(1);
            this.attemptInsertOnIndex(11, fuelDefinition.hasReturnType() ? new ItemStack((ItemLike)fuelDefinition.returnType()) : ItemStack.EMPTY);
            this.fuel += (float)fuelDefinition.fuel();
        }
        for (Integer i : (Set)this.disabledSlots.get()) {
            ItemStack stack = this.getItem(i);
            if (!stack.isEmpty()) {
                this.insertIntoHopperOrScatterAtFront(stack);
            }
            this.setItem(i, ItemStack.EMPTY);
        }
        float emptyFuelSpace = (float)this.forgeTier().fuelCapacity() - this.fuel;
        long fluidAmount = this.fluidHolder.getFluidAmountInDroplets();
        if (fluidAmount >= 81L && emptyFuelSpace > 0.0f) {
            float fuelInsertAmount = Math.min((float)fluidAmount / 81.0f, emptyFuelSpace / 24.0f);
            this.fuel += fuelInsertAmount * 24.0f;
            this.fluidHolder.setFluidAmountInDroplets((long)((float)fluidAmount - fuelInsertAmount * 81.0f));
        }
        BlockState currentBlockState = this.level.getBlockState(this.worldPosition);
        if (this.fuel > 100.0f && !((Boolean)currentBlockState.getValue((Property)ForgeControllerBlock.LIT)).booleanValue()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)currentBlockState.setValue((Property)ForgeControllerBlock.LIT, (Comparable)Boolean.valueOf(true)));
        } else if (this.fuel < 100.0f && ((Boolean)currentBlockState.getValue((Property)ForgeControllerBlock.LIT)).booleanValue()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)currentBlockState.setValue((Property)ForgeControllerBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
        if (this.isEmpty()) {
            this.currentSmeltTime = 0;
            return;
        }
        if (this.fuel < 5.0f || !this.checkForRecipes) {
            this.currentSmeltTime = 0;
            return;
        }
        AlloyForgeRecipeInput recipeInput = new AlloyForgeRecipeInput((Container)this);
        if (this.recipeCache.isEmpty() || !((AlloyForgeRecipe)this.recipeCache.get().value()).matches(recipeInput, this.level)) {
            this.recipeCache = this.level.getServer().getRecipeManager().getRecipeFor((RecipeType)AlloyForgeRecipe.Type.INSTANCE, (RecipeInput)recipeInput, this.level);
        }
        if (this.recipeCache.isEmpty() && (Integer)this.requiredTierToCraft.get() != -1) {
            this.requiredTierToCraft.set(-1);
        }
        if (this.recipeCache.isEmpty() || !this.canSmelt((AlloyForgeRecipe)this.recipeCache.get().value())) {
            this.checkForRecipes = false;
            this.currentSmeltTime = 0;
            return;
        }
        AlloyForgeRecipe recipe = (AlloyForgeRecipe)this.recipeCache.get().value();
        if (this.currentSmeltTime < this.forgeTier().maxSmeltTime()) {
            float fuelRequirement = (float)recipe.getFuelPerTick() * this.forgeTier().fuelConsumptionMultiplier();
            if (this.fuel - fuelRequirement < 0.0f) {
                this.currentSmeltTime = 0;
                return;
            }
            ++this.currentSmeltTime;
            this.fuel -= fuelRequirement;
            if (this.level.random.nextDouble() > 0.75) {
                AlloyForgery.FORGE_PARTICLES.spawn(this.level, Vec3.atLowerCornerOf((Vec3i)this.worldPosition), (Object)this.facing);
            }
        } else {
            NonNullList<ItemStack> remainderList = AlloyForgeRecipe.gatherRemainders(this.recipeCache.get(), recipeInput);
            if (remainderList != null) {
                this.handleForgingRemainders(remainderList);
            }
            ItemStack outputStack = this.getItem(10);
            ItemStack recipeOutput = recipe.craft(recipeInput, (HolderLookup.Provider)this.level.registryAccess());
            recipe.consumeIngredients(recipeInput);
            if (outputStack.isEmpty()) {
                this.setItem(10, recipeOutput);
            } else {
                outputStack.grow(recipeOutput.getCount());
            }
            this.currentSmeltTime = 0;
        }
    }

    private boolean canSmelt(AlloyForgeRecipe recipe) {
        ItemStack outputStack = this.getItem(10);
        ItemStack recipeOutput = recipe.getResult(this.forgeTier().value());
        if (recipe.getMinForgeTier() > this.forgeTier().value()) {
            this.requiredTierToCraft.set(recipe.getMinForgeTier());
            return false;
        }
        if ((Integer)this.requiredTierToCraft.get() != -1) {
            this.requiredTierToCraft.set(-1);
        }
        return outputStack.isEmpty() || ItemOps.canStack((ItemStack)outputStack, (ItemStack)recipeOutput);
    }

    private void handleForgingRemainders(NonNullList<ItemStack> remainderList) {
        for (int i = 0; i < remainderList.size(); ++i) {
            this.attemptInsertOnIndex(i, (ItemStack)remainderList.get(i));
        }
    }

    public void attemptInsertOnIndex(int i, ItemStack itemstack) {
        if (itemstack.isEmpty()) {
            return;
        }
        ItemStack slotStack = this.getItem(i);
        if (slotStack.isEmpty()) {
            this.setItem(i, itemstack);
        } else if (ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)itemstack) && ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)itemstack)) {
            itemstack.grow(slotStack.getCount());
            if (itemstack.getCount() > itemstack.getMaxStackSize()) {
                int excess = itemstack.getCount() - itemstack.getMaxStackSize();
                itemstack.shrink(excess);
                ItemStack insertStack = itemstack.copy();
                insertStack.setCount(excess);
                this.insertIntoHopperOrScatterAtFront(insertStack);
            }
            this.setItem(i, itemstack);
        } else {
            this.insertIntoHopperOrScatterAtFront(itemstack);
        }
    }

    private void insertIntoHopperOrScatterAtFront(ItemStack stack) {
        if (!this.attemptToInsertIntoHopper(stack)) {
            BlockPos frontForgePos = this.worldPosition.relative((Direction)this.getBlockState().getValue(ForgeControllerBlock.FACING));
            this.level.playSound(null, (double)frontForgePos.getX(), (double)frontForgePos.getY(), (double)frontForgePos.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 0.2f);
            Containers.dropItemStack((Level)this.level, (double)frontForgePos.getX(), (double)frontForgePos.getY(), (double)frontForgePos.getZ(), (ItemStack)stack);
        }
    }

    private boolean attemptToInsertIntoHopper(ItemStack remainderStack) {
        if (remainderStack.isEmpty()) {
            return true;
        }
        HopperBlockEntity blockEntity = null;
        for (int y = 1; y <= 2; ++y) {
            HopperBlockEntity hopperBlockEntity;
            BlockEntity blockEntity2 = this.level.getBlockEntity(this.worldPosition.below(y));
            if (!(blockEntity2 instanceof HopperBlockEntity)) continue;
            blockEntity = hopperBlockEntity = (HopperBlockEntity)blockEntity2;
            break;
        }
        if (blockEntity != null) {
            boolean isHopperEmpty = blockEntity.isEmpty();
            for (int slotIndex = 0; slotIndex < blockEntity.getContainerSize() && !remainderStack.isEmpty(); ++slotIndex) {
                if (!blockEntity.getItem(slotIndex).isEmpty()) {
                    ItemStack itemStack = blockEntity.getItem(slotIndex);
                    if (itemStack.isEmpty()) {
                        blockEntity.setItem(slotIndex, remainderStack);
                        remainderStack = ItemStack.EMPTY;
                        continue;
                    }
                    if (!ItemOps.canStack((ItemStack)itemStack, (ItemStack)remainderStack)) continue;
                    int availableSpace = itemStack.getMaxStackSize() - itemStack.getCount();
                    int j = Math.min(itemStack.getCount(), availableSpace);
                    remainderStack.shrink(j);
                    itemStack.grow(j);
                    continue;
                }
                blockEntity.setItem(slotIndex, remainderStack);
                break;
            }
            if (isHopperEmpty && !((HopperBlockEntityAccessor)blockEntity).alloyForge$isDisabled()) {
                ((HopperBlockEntityAccessor)blockEntity).alloyForge$setTransferCooldown(8);
            }
            blockEntity.setChanged();
            return true;
        }
        return false;
    }

    public boolean verifyMultiblock() {
        BlockState belowController = this.level.getBlockState((BlockPos)this.multiblockPositions.get(0));
        ForgeDefinition forgeDefinition = this.getForgeDefinition();
        if (!belowController.is(Blocks.HOPPER) && !forgeDefinition.isBlockValid(belowController.getBlock())) {
            return false;
        }
        for (int i = 1; i < this.multiblockPositions.size(); ++i) {
            if (forgeDefinition.isBlockValid(this.level.getBlockState((BlockPos)this.multiblockPositions.get(i)).getBlock())) continue;
            return false;
        }
        return true;
    }

    private static ImmutableList<BlockPos> generateMultiblockPositions(BlockPos controllerPos, Direction controllerFacing) {
        ArrayList<BlockPos> posses = new ArrayList<BlockPos>();
        BlockPos center = controllerPos.relative(controllerFacing.getOpposite());
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)center.offset(1, -1, 1), (BlockPos)center.offset(-1, -1, -1))) {
            posses.add(pos.immutable());
        }
        posses.remove(controllerPos.below());
        posses.add(0, controllerPos.below());
        for (int i = 0; i < 2; ++i) {
            BlockPos newCenter = center.offset(0, i, 0);
            posses.add(newCenter.east());
            posses.add(newCenter.west());
            posses.add(newCenter.north());
            posses.add(newCenter.south());
        }
        posses.remove(controllerPos);
        return ImmutableList.copyOf(posses);
    }

    public int[] getSlotsForFace(Direction side) {
        if (side == Direction.DOWN) {
            return DOWN_SLOTS;
        }
        if (side == this.facing.getClockWise()) {
            return LEFT_SLOTS;
        }
        if (side == this.facing.getCounterClockWise() && this.currentSmeltTime == 0) {
            return Arrays.stream(RIGHT_SLOTS).filter(i -> !((Set)this.disabledSlots.get()).contains(i)).mapToInt(value -> value).toArray();
        }
        return new int[0];
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
        if (slot == 11) {
            return ForgeFuelDataLoader.hasFuel(stack.getItem());
        }
        if (((Set)this.disabledSlots.get()).contains(slot)) {
            return false;
        }
        ItemStack slotStack = this.getItem(slot);
        return slotStack.isEmpty() || ItemOps.canStack((ItemStack)slotStack, (ItemStack)stack);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return slot == 10 || slot == 11 && !ForgeFuelDataLoader.hasFuel(stack.getItem());
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.alloy_forgery.forge_controller");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new AlloyForgeScreenHandler(syncId, inv, this);
    }
}

