/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.client;

import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public record BlockEntityLocation(BlockPos blockPos, ResourceKey<Level> worldKey) {
    public static final StructEndec<BlockEntityLocation> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.BLOCK_POS.fieldOf("blockPos", BlockEntityLocation::blockPos), (StructField)MinecraftEndecs.IDENTIFIER.xmap(id -> ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id), ResourceKey::location).fieldOf("dimensionType", BlockEntityLocation::worldKey), BlockEntityLocation::new);

    public static BlockEntityLocation of(BlockEntity blockEntity) {
        Level world = blockEntity.getLevel();
        if (world == null) {
            throw new IllegalStateException("Unable to create the needed BlockEntityLocation fro the given BlockEntity due to it missing its World!");
        }
        return new BlockEntityLocation(blockEntity.getBlockPos(), (ResourceKey<Level>)world.dimension());
    }

    public <T extends BlockEntity> T get(Player player, BlockEntityType<T> blockEntityType) {
        return this.get(player.level(), blockEntityType);
    }

    public <T extends BlockEntity> T get(Level world, BlockEntityType<T> blockEntityType) {
        if (!world.dimension().equals(this.worldKey())) {
            MinecraftServer server = world.getServer();
            if (server == null) {
                throw new IllegalStateException("Unable to get the given block entity due to a inability to get the needed server instance!");
            }
            world = server.getLevel(this.worldKey());
        }
        if (world == null) {
            throw new IllegalStateException("Unable to get the given block entity due to a inability to get the needed origin world! [World: " + String.valueOf(this.worldKey().location()) + "]");
        }
        return (T)((BlockEntity)world.getBlockEntity(this.blockPos(), blockEntityType).orElseThrow(() -> new IllegalStateException("Unable to get the given block entity due not finding any block entity at the given location! [World: " + String.valueOf(this.worldKey().location()) + ", Pos: " + String.valueOf(this.blockPos()) + "]")));
    }
}

