/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.compat.emi;

import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix3x2fStack;

public class CustomTextWidget
extends Widget {
    private static final Minecraft CLIENT = Minecraft.getInstance();
    private FormattedCharSequence text;
    private final int x;
    private final int y;
    private final int color;
    private final boolean shadow;

    public CustomTextWidget(FormattedCharSequence text, int x, int y, int color, boolean shadow) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.color = color;
        this.shadow = shadow;
    }

    public void setText(FormattedCharSequence text) {
        this.text = text;
    }

    public Bounds getBounds() {
        int width = CustomTextWidget.CLIENT.font.width(this.text);
        int xOff = TextWidget.Alignment.START.offset(width);
        Objects.requireNonNull(CustomTextWidget.CLIENT.font);
        int yOff = TextWidget.Alignment.START.offset(9);
        Objects.requireNonNull(CustomTextWidget.CLIENT.font);
        return new Bounds(this.x + xOff, this.y + yOff, width, 9);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        Matrix3x2fStack matrices = context.pose();
        matrices.pushMatrix();
        int xOff = TextWidget.Alignment.START.offset(CustomTextWidget.CLIENT.font.width(this.text));
        Objects.requireNonNull(CustomTextWidget.CLIENT.font);
        int yOff = TextWidget.Alignment.START.offset(9);
        matrices.translate((float)xOff, (float)yOff);
        context.drawString(CustomTextWidget.CLIENT.font, this.text, this.x, this.y, this.color, this.shadow);
        matrices.popMatrix();
    }
}

