/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.data.builders;

import com.google.common.collect.Streams;
import com.mojang.logging.LogUtils;
import io.wispforest.alloyforgery.data.providers.RecipeExporterConditionWrapper;
import io.wispforest.alloyforgery.data.providers.ResourceConditionHolder;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipe;
import io.wispforest.alloyforgery.recipe.OutputData;
import io.wispforest.alloyforgery.recipe.RawAlloyForgeRecipe;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AlloyForgeryRecipeBuilder
implements RecipeBuilder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, Criterion<?>> advancementBuilder = new LinkedHashMap();
    private String group = "";
    private final Set<TagKey<Item>> inputTags = new LinkedHashSet<TagKey<Item>>();
    @Nullable
    private final TagKey<Item> outputTag;
    @Nullable
    private final ItemLike outputItem;
    private final int outputCount;
    private final Map<Ingredient, Integer> inputs = new LinkedHashMap<Ingredient, Integer>();
    private final Map<AlloyForgeRecipe.OverrideRange, AlloyForgeRecipe.PendingOverride> ranges = new LinkedHashMap<AlloyForgeRecipe.OverrideRange, AlloyForgeRecipe.PendingOverride>();
    private final List<ResourceLocation> priorities = new ArrayList<ResourceLocation>();
    private int minimumTier = 1;
    private int fuelPerTick = 5;

    private AlloyForgeryRecipeBuilder(@Nullable TagKey<Item> outputTag, @Nullable ItemLike outputItem, int outputCount) {
        this.outputTag = outputTag;
        this.outputItem = outputItem;
        this.outputCount = outputCount;
    }

    public static AlloyForgeryRecipeBuilder create(ItemLike output) {
        return AlloyForgeryRecipeBuilder.create(output, 1);
    }

    public static AlloyForgeryRecipeBuilder create(ItemLike output, int outputCount) {
        return new AlloyForgeryRecipeBuilder(null, output, outputCount);
    }

    public static AlloyForgeryRecipeBuilder create(TagKey<Item> outputTag) {
        return AlloyForgeryRecipeBuilder.create(outputTag, 1);
    }

    public static AlloyForgeryRecipeBuilder create(TagKey<Item> outputTag, int outputCount) {
        return new AlloyForgeryRecipeBuilder(outputTag, null, outputCount);
    }

    public AlloyForgeryRecipeBuilder addPriorityOutput(ItemLike ... outputs) {
        return this.addPriorityOutput((ResourceLocation[])Arrays.stream(outputs).map(output -> BuiltInRegistries.ITEM.getKey((Object)output.asItem())).toArray(ResourceLocation[]::new));
    }

    public AlloyForgeryRecipeBuilder addPriorityOutput(ResourceLocation ... outputId) {
        return this.addPriorityOutput(List.of(outputId));
    }

    public AlloyForgeryRecipeBuilder addPriorityOutput(List<ResourceLocation> outputIds) {
        this.priorities.addAll(outputIds);
        return this;
    }

    public AlloyForgeryRecipeBuilder tagInputs(HolderGetter<Item> registryLookup, Map<TagKey<Item>, Integer> inputs) {
        inputs.forEach((itemTagKey, integer) -> this.input(registryLookup, (TagKey<Item>)itemTagKey, (int)integer));
        return this;
    }

    public AlloyForgeryRecipeBuilder input(HolderGetter<Item> registryLookup, TagKey<Item> input, int count) {
        this.inputTags.add(input);
        this.inputs.put(Ingredient.of((HolderSet)registryLookup.getOrThrow(input)), count);
        return this;
    }

    public AlloyForgeryRecipeBuilder itemInputs(Map<ItemLike, Integer> inputs) {
        inputs.forEach(this::input);
        return this;
    }

    public AlloyForgeryRecipeBuilder input(ItemLike input, int count) {
        this.inputs.put(Ingredient.of((ItemLike[])new ItemLike[]{input}), count);
        return this;
    }

    public AlloyForgeryRecipeBuilder input(ItemStack inputStack) {
        Ingredient ingredient = GeneralPlatformUtils.INSTANCE.createStackIngredient(inputStack);
        this.inputs.put(ingredient, inputStack.getCount());
        return this;
    }

    public AlloyForgeryRecipeBuilder overrideRange(AlloyForgeRecipe.OverrideRange range, AlloyForgeRecipe.PendingOverride override) {
        this.ranges.put(range, override);
        return this;
    }

    public AlloyForgeryRecipeBuilder overrideRange(int start, int end, int outputCount) {
        return this.overrideRange(start, end, null, outputCount);
    }

    public AlloyForgeryRecipeBuilder overrideRange(int start, int end, @Nullable ItemLike output, int outputCount) {
        this.ranges.put(new AlloyForgeRecipe.OverrideRange(start, end), new AlloyForgeRecipe.PendingOverride(output != null ? output.asItem() : null, outputCount, DataComponentPatch.EMPTY));
        return this;
    }

    public AlloyForgeryRecipeBuilder overrideRange(int index, int outputCount) {
        return this.overrideRange(index, false, null, outputCount);
    }

    public AlloyForgeryRecipeBuilder overrideRange(int index, boolean includeUpperValues, int outputCount) {
        return this.overrideRange(index, includeUpperValues, null, outputCount);
    }

    public AlloyForgeryRecipeBuilder overrideRange(int index, boolean includeUpperValues, @Nullable ItemLike output, int outputCount) {
        this.ranges.put(new AlloyForgeRecipe.OverrideRange(index, includeUpperValues ? -1 : index), new AlloyForgeRecipe.PendingOverride(output != null ? output.asItem() : null, outputCount, DataComponentPatch.EMPTY));
        return this;
    }

    public AlloyForgeryRecipeBuilder setMinimumForgeTier(int tier) {
        this.minimumTier = tier;
        return this;
    }

    public AlloyForgeryRecipeBuilder setFuelPerTick(int fuelAmount) {
        this.fuelPerTick = fuelAmount;
        return this;
    }

    public AlloyForgeryRecipeBuilder criterion(String string, Criterion criterion) {
        this.advancementBuilder.put(string, criterion);
        return this;
    }

    public <T> AlloyForgeryRecipeBuilder criterion(String string, Map<T, Integer> inputs, Function<T, Criterion> criterionMaker) {
        inputs.keySet().forEach(itemTagKey -> this.criterion(string, (Criterion)criterionMaker.apply(itemTagKey)));
        return this;
    }

    public AlloyForgeryRecipeBuilder group(@Nullable String string) {
        this.group = string;
        return this;
    }

    public Item getResult() {
        return Items.AIR;
    }

    public void save(RecipeOutput exporter, ResourceKey<Recipe<?>> recipeId) {
        ResourceLocation advancementId = ResourceLocation.fromNamespaceAndPath((String)recipeId.location().getNamespace(), (String)("recipes/alloy_forgery/" + recipeId.location().getPath()));
        this.validate(recipeId.location());
        Advancement.Builder builder = exporter.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked(recipeId)).rewards(AdvancementRewards.Builder.recipe(recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.advancementBuilder.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        RawAlloyForgeRecipe recipe = new RawAlloyForgeRecipe(this.inputs, new OutputData(this.outputCount, this.outputItem != null ? this.outputItem.asItem() : null, this.priorities.isEmpty() ? null : this.priorities, this.outputTag), this.minimumTier, this.fuelPerTick, this.ranges);
        exporter.accept(recipeId, (Recipe)recipe.generateRecipe(true), builder.build(advancementId));
    }

    public void offerTo(RecipeOutput exporter, ResourceLocation recipeId) {
        this.save(exporter, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)recipeId));
    }

    public void save(RecipeOutput exporter) {
        this.offerTo(exporter, this.getOutputId());
    }

    public void save(RecipeOutput exporter, String recipePath) {
        ResourceLocation identifier2 = ResourceLocation.parse((String)recipePath);
        if (identifier2.equals((Object)this.getOutputId())) {
            throw new IllegalStateException("Recipe " + recipePath + " should remove its 'save' argument as it is equal to default one");
        }
        this.offerTo(exporter, identifier2);
    }

    public void offerToWithConditions(RecipeOutput exporter, String recipePath, RecipeExporterConditionWrapper withConditionsWrapper) {
        TagKey[] tags = (TagKey[])Streams.concat((Stream[])new Stream[]{this.inputTags.stream(), Stream.of(this.outputTag)}).toArray(TagKey[]::new);
        exporter = withConditionsWrapper.withConditions(exporter, ResourceConditionHolder.createConditions().withTags(Registries.ITEM, tags));
        this.save(exporter, recipePath);
    }

    public void validate(ResourceLocation recipeId) {
        if (this.advancementBuilder.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeId));
        }
        if (this.inputs.isEmpty()) {
            throw new IllegalStateException("Missing inputs meaning such cannot be made " + String.valueOf(recipeId));
        }
    }

    private ResourceLocation getOutputId() {
        return this.outputTag != null ? this.outputTag.location() : BuiltInRegistries.ITEM.getKey((Object)this.outputItem.asItem());
    }
}

