/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.data.providers;

import io.wispforest.alloyforgery.data.AlloyForgeryTags;
import io.wispforest.alloyforgery.data.builders.AlloyForgeryRecipeBuilder;
import io.wispforest.alloyforgery.data.providers.RecipeExporterConditionWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class AlloyForgeryBaseRecipeProvider
extends RecipeProvider {
    protected final RecipeExporterConditionWrapper withConditionsWrapper;
    private final Map<String, MaterialRank> materialRanking = new HashMap<String, MaterialRank>();
    private final Map<MaterialRecipeType, Map<String, MaterialRecipe>> compatibilityRecipes = new HashMap<MaterialRecipeType, Map<String, MaterialRecipe>>();
    private Map<String, String> commonInputExceptions = new HashMap<String, String>();
    public static final TagKey<Item> STORAGE_BLOCKS_RAW_COPPER = AlloyForgeryBaseRecipeProvider.register("storage_blocks/raw_copper");
    public static final TagKey<Item> STORAGE_BLOCKS_RAW_GOLD = AlloyForgeryBaseRecipeProvider.register("storage_blocks/raw_gold");
    public static final TagKey<Item> STORAGE_BLOCKS_RAW_IRON = AlloyForgeryBaseRecipeProvider.register("storage_blocks/raw_iron");

    public AlloyForgeryBaseRecipeProvider(RecipeOutput recipeExporter, HolderLookup.Provider registryLookup, RecipeExporterConditionWrapper withConditionsWrapper) {
        super(registryLookup, recipeExporter);
        this.withConditionsWrapper = withConditionsWrapper;
    }

    public MaterialRank getOrCreateRank(String materialName, RecipeRank purposedRank) {
        return this.materialRanking.computeIfAbsent(materialName, name -> new MaterialRank((String)name, purposedRank));
    }

    public void createMaterialRecipesWithRank(String materialName, RecipeRank purposedRank, String ... modids) {
        this.materialRanking.computeIfAbsent(materialName, name -> new MaterialRank((String)name, purposedRank)).createMaterialRecipes(modids);
    }

    public void registerCommonInputExceptions(String templatedPath, String properPath) {
        if (this.commonInputExceptions.containsKey(templatedPath)) {
            throw new IllegalStateException("Unable to add exception to templated paths as it already was registered: " + templatedPath);
        }
        this.commonInputExceptions.put(templatedPath, properPath);
    }

    private static TagKey<Item> register(String tagId) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)tagId));
    }

    public void generateAlloyForgeryRecipes() {
    }

    public final void buildRecipes() {
        this.generateAlloyForgeryRecipes();
        this.compatibilityRecipes.forEach((recipeType, recipeMap) -> {
            for (MaterialRecipe materialRecipe : recipeMap.values()) {
                block0 : switch (materialRecipe.recipeTypes.ordinal()) {
                    case 0: {
                        switch (materialRecipe.rank.ordinal()) {
                            case 0: {
                                this.exportStandardRawOreRecipe(materialRecipe.materialName, materialRecipe.modids, materialRecipe.additionalPriorities);
                                break block0;
                            }
                            case 1: {
                                this.exportAdvancedRawOreRecipe(materialRecipe.materialName, materialRecipe.modids, materialRecipe.additionalPriorities);
                                break block0;
                            }
                            case 2: {
                                this.exportExtremeRawOreRecipe(materialRecipe.materialName, materialRecipe.modids, materialRecipe.additionalPriorities);
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (materialRecipe.rank.ordinal()) {
                            case 0: {
                                this.exportStandardRawBlockRecipe(materialRecipe.materialName, materialRecipe.modids, materialRecipe.additionalPriorities);
                                break block0;
                            }
                            case 1: {
                                this.exportAdvancedRawBlockRecipe(materialRecipe.materialName, materialRecipe.modids, materialRecipe.additionalPriorities);
                                break block0;
                            }
                            case 2: {
                                this.exportExtremeRawBlockRecipe(materialRecipe.materialName, materialRecipe.modids, materialRecipe.additionalPriorities);
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (materialRecipe.rank.ordinal()) {
                            case 0: {
                                this.exportStandardOreRecipe(materialRecipe.materialName, materialRecipe.modids, materialRecipe.additionalPriorities);
                                break block0;
                            }
                            case 1: {
                                this.exportAdvancedOreRecipe(materialRecipe.materialName, materialRecipe.modids, materialRecipe.additionalPriorities);
                                break block0;
                            }
                            case 2: {
                                this.exportExtremeOreRecipe(materialRecipe.materialName, materialRecipe.modids, materialRecipe.additionalPriorities);
                            }
                        }
                    }
                }
            }
        });
    }

    public AlloyForgeryRecipeBuilder createStandardRawBlockRecipe(String criterionName, TagKey<Item> output, TagKey<Item> input) {
        return this.createAFRecipeWithOverride(criterionName, output, input, 2, 3, 2, 4, 45);
    }

    public AlloyForgeryRecipeBuilder createAdvancedRawBlockRecipe(String criterionName, TagKey<Item> output, TagKey<Item> input) {
        return this.createAFRecipeWithOverride(criterionName, output, input, 2, 2, 3, 3, 90).setMinimumForgeTier(2);
    }

    public AlloyForgeryRecipeBuilder createExtremeRawBlockRecipe(String criterionName, TagKey<Item> output, TagKey<Item> input) {
        return this.createAFRecipeWithOverride(criterionName, output, input, 2, 2, 3, 3, 135).setMinimumForgeTier(2);
    }

    public AlloyForgeryRecipeBuilder createStandardRawOreRecipe(String criterionName, TagKey<Item> output, TagKey<Item> input) {
        return this.createAFRecipeWithOverride(criterionName, output, input, 2, 3, 2, 4, 45);
    }

    public AlloyForgeryRecipeBuilder createAdvancedRawOreRecipe(String criterionName, TagKey<Item> output, TagKey<Item> input) {
        return this.createAFRecipeWithOverride(criterionName, output, input, 2, 2, 3, 3, 90).setMinimumForgeTier(2);
    }

    public AlloyForgeryRecipeBuilder createExtremeRawOreRecipe(String criterionName, TagKey<Item> output, TagKey<Item> input) {
        return this.createAFRecipeWithOverride(criterionName, output, input, 2, 2, 3, 3, 135).setMinimumForgeTier(2);
    }

    public AlloyForgeryRecipeBuilder createStandardOreRecipe(String criterionName, TagKey<Item> output, TagKey<Item> input) {
        return this.createAFRecipeWithOverride(criterionName, output, input, 2, 3, 2, 4, 45);
    }

    public AlloyForgeryRecipeBuilder createAdvancedOreRecipe(String criterionName, TagKey<Item> output, TagKey<Item> input) {
        return this.createAFRecipeWithOverride(criterionName, output, input, 2, 2, 3, 3, 90).setMinimumForgeTier(2);
    }

    public AlloyForgeryRecipeBuilder createExtremeOreRecipe(String criterionName, TagKey<Item> output, TagKey<Item> input) {
        return this.createAFRecipeWithOverride(criterionName, output, input, 2, 2, 3, 3, 135).setMinimumForgeTier(2);
    }

    public AlloyForgeryRecipeBuilder createRawBlockRecipe(String criterionName, Item output, TagKey<Item> input) {
        return AlloyForgeryRecipeBuilder.create((ItemLike)output, 3).input((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), input, 2).criterion("has_" + criterionName, this.has(input)).overrideRange(2, true, 4).setFuelPerTick(45);
    }

    public AlloyForgeryRecipeBuilder createAFRecipeWithOverride(String inputCriterionName, TagKey<Item> output, TagKey<Item> input, int inputAmount, int outputAmount, int overrideIndex, int overrideAmount, int fuelPerTick) {
        return this.createAFRecipeWithOverride(inputCriterionName, output, new LinkedHashMap<TagKey<Item>, Integer>(Map.of(input, inputAmount)), outputAmount, overrideIndex, overrideAmount, fuelPerTick);
    }

    public AlloyForgeryRecipeBuilder createAFRecipeWithOverride(String inputCriterionName, TagKey<Item> output, SequencedMap<TagKey<Item>, Integer> inputs, int outputAmount, int overrideIndex, int overrideAmount, int fuelPerTick) {
        return this.createAFRecipeWithOverrides(inputCriterionName, output, inputs, outputAmount, new LinkedHashMap<Integer, Integer>(Map.of(overrideIndex, overrideAmount)), fuelPerTick);
    }

    public AlloyForgeryRecipeBuilder createAFRecipe(String inputCriterionName, TagKey<Item> output, Consumer<SequencedMap<TagKey<Item>, Integer>> inputs, int outputAmount, int fuelPerTick) {
        return this.createAFRecipeWithOverrides(inputCriterionName, output, inputs, outputAmount, (SequencedMap<Integer, Integer> map) -> {}, fuelPerTick);
    }

    public AlloyForgeryRecipeBuilder createAFRecipeWithOverrides(String inputCriterionName, TagKey<Item> output, Consumer<SequencedMap<TagKey<Item>, Integer>> inputs, int outputAmount, Consumer<SequencedMap<Integer, Integer>> overrides, int fuelPerTick) {
        return this.createAFRecipeWithOverrides(inputCriterionName, output, (SequencedMap)Util.make(new LinkedHashMap(), inputs), outputAmount, (SequencedMap)Util.make(new LinkedHashMap(), overrides), fuelPerTick);
    }

    public AlloyForgeryRecipeBuilder createAFRecipe(String inputCriterionName, TagKey<Item> output, SequencedMap<TagKey<Item>, Integer> inputs, int outputAmount, int fuelPerTick) {
        return this.createAFRecipeWithOverrides(inputCriterionName, output, inputs, outputAmount, new LinkedHashMap<Integer, Integer>(), fuelPerTick);
    }

    public AlloyForgeryRecipeBuilder createAFRecipeWithOverrides(String inputCriterionName, TagKey<Item> output, SequencedMap<TagKey<Item>, Integer> inputs, int outputAmount, SequencedMap<Integer, Integer> overrides, int fuelPerTick) {
        AlloyForgeryRecipeBuilder builder = AlloyForgeryRecipeBuilder.create(output, outputAmount).tagInputs((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), inputs).criterion("has_" + inputCriterionName, inputs, x$0 -> this.has((TagKey)x$0)).setFuelPerTick(fuelPerTick);
        overrides.forEach((overrideIndex, overrideAmount) -> builder.overrideRange((int)overrideIndex, true, (int)overrideAmount));
        return builder;
    }

    public void exportCompatRecipe(AFRBuilderMethod builder, String materialName, String recipeTemplate, String inputTagTemplate, String outputTagTemplate, String priorityTemplate, List<String> modids, List<ResourceLocation> additionalPriorities) {
        List priorities = modids.stream().map(modid -> ResourceLocation.fromNamespaceAndPath((String)modid, (String)(materialName + priorityTemplate))).collect(Collectors.toList());
        priorities.addAll(additionalPriorities);
        this.exportCompatRecipe(builder, materialName + recipeTemplate, AlloyForgeryTags.Items.common(inputTagTemplate + materialName), AlloyForgeryTags.Items.common(outputTagTemplate + materialName), (ResourceLocation[])priorities.toArray(ResourceLocation[]::new));
    }

    public void exportCompatRecipe(AFRBuilderMethod builder, String name, TagKey<Item> input, TagKey<Item> output, ResourceLocation ... priorities) {
        this.exportCompatRecipe(name, builder.build(name, output, input).addPriorityOutput(priorities));
    }

    public void exportCompatRecipe(String name, AlloyForgeryRecipeBuilder builder) {
        this.exportRecipe("compat/forge_" + name, builder);
    }

    public void exportAlloyCompatRecipe(String name, AlloyForgeryRecipeBuilder builder) {
        this.exportRecipe("compat/alloys/forge_" + name, builder);
    }

    public void exportRecipe(String name, AlloyForgeryRecipeBuilder builder) {
        builder.offerToWithConditions(this.output, name, this.withConditionsWrapper);
    }

    public void exportStandardRawBlockRecipe(String materialName, String ... modids) {
        this.exportStandardRawBlockRecipe(materialName, Arrays.stream(modids).toList(), List.of());
    }

    public void exportStandardRawBlockRecipe(String materialName, List<String> modids, List<ResourceLocation> additionalPriorities) {
        this.exportCompatRecipe(this::createStandardRawBlockRecipe, materialName, "_blocks", "storage_blocks/raw_", "storage_blocks/", "_block", modids, additionalPriorities);
    }

    public void exportAdvancedRawBlockRecipe(String materialName, String ... modids) {
        this.exportAdvancedRawBlockRecipe(materialName, Arrays.stream(modids).toList(), List.of());
    }

    public void exportAdvancedRawBlockRecipe(String materialName, List<String> modids, List<ResourceLocation> additionalPriorities) {
        this.exportCompatRecipe(this::createAdvancedRawBlockRecipe, materialName, "_blocks", "storage_blocks/raw_", "storage_blocks/", "_block", modids, additionalPriorities);
    }

    public void exportExtremeRawBlockRecipe(String materialName, String ... modids) {
        this.exportExtremeRawBlockRecipe(materialName, Arrays.stream(modids).toList(), List.of());
    }

    public void exportExtremeRawBlockRecipe(String materialName, List<String> modids, List<ResourceLocation> additionalPriorities) {
        this.exportCompatRecipe(this::createExtremeRawBlockRecipe, materialName, "_blocks", "storage_blocks/raw_", "storage_blocks/", "_block", modids, additionalPriorities);
    }

    public void exportStandardRawOreRecipe(String materialName, String ... modids) {
        this.exportStandardRawOreRecipe(materialName, Arrays.stream(modids).toList(), List.of());
    }

    public void exportStandardRawOreRecipe(String materialName, List<String> modids, List<ResourceLocation> additionalPriorities) {
        this.exportCompatRecipe(this::createStandardRawOreRecipe, materialName, "_ingots_from_raw_material", "raw_materials/", "ingots/", "_ingot", modids, additionalPriorities);
    }

    public void exportAdvancedRawOreRecipe(String materialName, String ... modids) {
        this.exportAdvancedRawOreRecipe(materialName, Arrays.stream(modids).toList(), List.of());
    }

    public void exportAdvancedRawOreRecipe(String materialName, List<String> modids, List<ResourceLocation> additionalPriorities) {
        this.exportCompatRecipe(this::createAdvancedRawOreRecipe, materialName, "_ingots_from_raw_material", "raw_materials/", "ingots/", "_ingot", modids, additionalPriorities);
    }

    public void exportExtremeRawOreRecipe(String materialName, String ... modids) {
        this.exportExtremeRawOreRecipe(materialName, Arrays.stream(modids).toList(), List.of());
    }

    public void exportExtremeRawOreRecipe(String materialName, List<String> modids, List<ResourceLocation> additionalPriorities) {
        this.exportCompatRecipe(this::createExtremeRawOreRecipe, materialName, "_ingots_from_raw_material", "raw_materials/", "ingots/", "_ingot", modids, additionalPriorities);
    }

    public void exportStandardOreRecipe(String materialName, String ... modids) {
        this.exportStandardOreRecipe(materialName, Arrays.stream(modids).toList(), List.of());
    }

    public void exportStandardOreRecipe(String materialName, List<String> modids, List<ResourceLocation> additionalPriorities) {
        this.exportCompatRecipe(this::createStandardOreRecipe, materialName, "_ingots_from_ores", "ores/", "ingots/", "_ingot", modids, additionalPriorities);
    }

    public void exportAdvancedOreRecipe(String materialName, String ... modids) {
        this.exportAdvancedOreRecipe(materialName, Arrays.stream(modids).toList(), List.of());
    }

    public void exportAdvancedOreRecipe(String materialName, List<String> modids, List<ResourceLocation> additionalPriorities) {
        this.exportCompatRecipe(this::createAdvancedOreRecipe, materialName, "_ingots_from_ores", "ores/", "ingots/", "_ingot", modids, additionalPriorities);
    }

    public void exportExtremeOreRecipe(String materialName, String ... modids) {
        this.exportExtremeOreRecipe(materialName, Arrays.stream(modids).toList(), List.of());
    }

    public void exportExtremeOreRecipe(String materialName, List<String> modids, List<ResourceLocation> additionalPriorities) {
        this.exportCompatRecipe(this::createExtremeOreRecipe, materialName, "_ingots_from_ores", "ores/", "ingots/", "_ingot", modids, additionalPriorities);
    }

    public void createAlloyingRecipes(String materialName, int outputAmount, Consumer<SequencedMap<String, Integer>> materialInputs, Consumer<SequencedMap<Integer, Integer>> overridesMap, int forgeTier, int fuelPerTick, String ... modids) {
        this.createAlloyingRecipes(materialName, outputAmount, materialInputs, overridesMap, forgeTier, fuelPerTick, Arrays.stream(modids).toList(), List.of());
    }

    public void createAlloyingRecipes(String materialName, int outputAmount, Consumer<SequencedMap<String, Integer>> materialInputs, Consumer<SequencedMap<Integer, Integer>> overridesMap, int forgeTier, int fuelPerTick, List<String> modids, List<ResourceLocation> additionalPriorities) {
        Function<String, SequencedMap> inputBuilder = materialType -> ((LinkedHashMap)Util.make(new LinkedHashMap(), (Consumer)materialInputs)).entrySet().stream().map(entry -> {
            Object path = materialType + (String)entry.getKey();
            path = this.commonInputExceptions.getOrDefault(path, (String)path);
            return Map.entry(AlloyForgeryTags.Items.common((String)path), (Integer)entry.getValue());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (i1, i2) -> i1, LinkedHashMap::new));
        List list = ((LinkedHashMap)Util.make(new LinkedHashMap(), overridesMap)).entrySet().stream().toList();
        Function<Integer, SequencedMap> overrideBuilder = maxIndex -> (SequencedMap)Util.make(new LinkedHashMap(), map -> {
            for (int i = 0; i < maxIndex && i < list.size(); ++i) {
                Map.Entry entry = (Map.Entry)list.get(i);
                map.put((Integer)entry.getKey(), (Integer)entry.getValue());
            }
        });
        ArrayList<ResourceLocation> priorities = new ArrayList<ResourceLocation>(additionalPriorities);
        priorities.addAll(modids.stream().map(modid -> ResourceLocation.fromNamespaceAndPath((String)modid, (String)(materialName + "_ingot"))).toList());
        this.exportAlloyCompatRecipe(materialName + "_from_ingots", this.createAFRecipe(materialName, AlloyForgeryTags.Items.common("ingots/" + materialName), inputBuilder.apply("ingots/"), outputAmount, fuelPerTick).addPriorityOutput(priorities).setMinimumForgeTier(forgeTier));
        this.exportAlloyCompatRecipe(materialName + "_from_raw_ores", this.createAFRecipeWithOverrides(materialName, AlloyForgeryTags.Items.common("ingots/" + materialName), inputBuilder.apply("raw_materials/"), outputAmount, overrideBuilder.apply(1), fuelPerTick).addPriorityOutput(priorities).setMinimumForgeTier(forgeTier));
        this.exportAlloyCompatRecipe(materialName + "_from_raw_ore_blocks", this.createAFRecipeWithOverrides(materialName, AlloyForgeryTags.Items.common("storage_blocks/" + materialName), inputBuilder.apply("storage_blocks/raw_"), outputAmount, overrideBuilder.apply(1), fuelPerTick * 9).addPriorityOutput(priorities).setMinimumForgeTier(forgeTier));
        this.exportAlloyCompatRecipe(materialName + "_from_ores", this.createAFRecipeWithOverrides(materialName, AlloyForgeryTags.Items.common("ingots/" + materialName), inputBuilder.apply("ores/"), outputAmount, overrideBuilder.apply(2), fuelPerTick).addPriorityOutput(priorities).setMinimumForgeTier(forgeTier));
    }

    public static enum RecipeRank {
        STANDARD,
        ADVANCED,
        EXTREME;

    }

    public final class MaterialRank {
        private final String materialName;
        private final RecipeRank rank;

        public MaterialRank(String materialName, RecipeRank rank) {
            this.materialName = materialName;
            this.rank = rank;
        }

        public void createMaterialRecipes(String ... modids) {
            for (MaterialRecipeType value : MaterialRecipeType.values()) {
                this.createMaterialRecipe(value, modids);
            }
        }

        public void createMaterialRecipes(ResourceLocation ... additionalPriorities) {
            for (MaterialRecipeType value : MaterialRecipeType.values()) {
                this.createMaterialRecipe(value, additionalPriorities);
            }
        }

        public void createMaterialRecipe(MaterialRecipeType recipeType, String ... modids) {
            MaterialRecipe holder = AlloyForgeryBaseRecipeProvider.this.compatibilityRecipes.computeIfAbsent(recipeType, type -> new HashMap()).computeIfAbsent(this.materialName, name -> new MaterialRecipe((String)name, this.rank, recipeType));
            for (String modid : modids) {
                holder.addModid(modid);
            }
        }

        public void createMaterialRecipe(MaterialRecipeType recipeType, ResourceLocation ... additionalPriorities) {
            MaterialRecipe holder = AlloyForgeryBaseRecipeProvider.this.compatibilityRecipes.computeIfAbsent(recipeType, type -> new HashMap()).computeIfAbsent(this.materialName, name -> new MaterialRecipe((String)name, this.rank, recipeType));
            for (ResourceLocation id : additionalPriorities) {
                holder.addPriority(id);
            }
        }
    }

    public static interface AFRBuilderMethod {
        public AlloyForgeryRecipeBuilder build(String var1, TagKey<Item> var2, TagKey<Item> var3);
    }

    public static final class MaterialRecipe {
        private final String materialName;
        private final RecipeRank rank;
        private final MaterialRecipeType recipeTypes;
        private final List<String> modids = new ArrayList<String>();
        private final List<ResourceLocation> additionalPriorities = new ArrayList<ResourceLocation>();

        public MaterialRecipe(String materialName, RecipeRank rank, MaterialRecipeType recipeTypes) {
            this.materialName = materialName;
            this.rank = rank;
            this.recipeTypes = recipeTypes;
        }

        public void addModid(String modid) {
            this.modids.add(modid);
        }

        public void addPriority(ResourceLocation id) {
            this.additionalPriorities.add(id);
        }
    }

    public static enum MaterialRecipeType {
        RAW_ORE,
        RAW_ORE_BLOCK,
        ORE_BLOCK;

    }
}

