/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.forges;

import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.forges.ForgeTierDataLoader;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public final class ForgeTier {
    public static final ResourceLocation DEFAULT_ID = AlloyForgery.id("default");
    public static final ForgeTier DEFAULT = new ForgeTier(DEFAULT_ID, 1, 1.0f, 48000);
    public static final Endec<ForgeTier> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.fieldOf("id", ForgeTier::id), (StructField)Endec.INT.fieldOf("tier", ForgeTier::value), (StructField)Endec.FLOAT.fieldOf("speed_multiplier", ForgeTier::speedMultiplier), (StructField)Endec.FLOAT.fieldOf("fuel_consumption_multiplier", ForgeTier::fuelConsumptionMultiplier), (StructField)Endec.INT.fieldOf("fuel_capacity", ForgeTier::fuelCapacity), ForgeTier::new);
    public static final int BASE_MAX_SMELT_TIME = 200;
    private final ResourceLocation id;
    private final int value;
    private final float speedMultiplier;
    private final float fuelConsumptionMultiplier;
    private final int fuelCapacity;

    public ForgeTier(ResourceLocation id, int value, float speedMultiplier, float fuelConsumptionMultiplier, int fuelCapacity) {
        this.id = id;
        this.value = value;
        this.speedMultiplier = speedMultiplier;
        this.fuelConsumptionMultiplier = fuelConsumptionMultiplier;
        this.fuelCapacity = fuelCapacity;
    }

    public ForgeTier(ResourceLocation id, int value, float speedMultiplier, int fuelCapacity) {
        this(id, value, speedMultiplier, speedMultiplier, fuelCapacity);
    }

    @Deprecated(forRemoval=true)
    public ForgeTier(ResourceLocation id, int forgeTier, float speedMultiplier, int fuelCapacity, Optional<Integer> maxSmeltTime) {
        this(id, forgeTier, maxSmeltTime.map(integer -> Float.valueOf((float)integer.intValue() / 200.0f)).orElse(Float.valueOf(speedMultiplier)).floatValue(), speedMultiplier, fuelCapacity);
    }

    public ResourceLocation id() {
        return this.id;
    }

    public int value() {
        return this.value;
    }

    public float speedMultiplier() {
        return this.speedMultiplier;
    }

    public float fuelConsumptionMultiplier() {
        return this.fuelConsumptionMultiplier;
    }

    public int fuelCapacity() {
        return this.fuelCapacity;
    }

    public int maxSmeltTime() {
        return (int)(200.0f / this.speedMultiplier);
    }

    public Component name(boolean advancedName) {
        return Component.translatable((String)this.id.toLanguageKey("alloy_forgery.tier." + (advancedName ? "advanced_" : "") + "name"), (Object[])new Object[]{this.value});
    }

    public static Component toName(boolean isClientSide, int value) {
        ForgeTier tier = ForgeTierDataLoader.getForgeRegistry(isClientSide).getPrimaryTier(value);
        return tier != null ? tier.name(true) : Component.literal((String)String.valueOf(value));
    }

    public void tooltip(boolean advancedName, Consumer<Component> tooltipCallback) {
        tooltipCallback.accept((Component)Component.translatable((String)"tooltip.alloy_forgery.forge_tier", (Object[])new Object[]{this.name(advancedName)}).withStyle(ChatFormatting.GRAY));
        tooltipCallback.accept((Component)Component.translatable((String)"tooltip.alloy_forgery.speed_multiplier", (Object[])new Object[]{Float.valueOf(this.speedMultiplier())}).withStyle(ChatFormatting.GRAY));
        tooltipCallback.accept((Component)Component.translatable((String)"tooltip.alloy_forgery.fuel_consumption_multiplier", (Object[])new Object[]{Float.valueOf(this.fuelConsumptionMultiplier())}).withStyle(ChatFormatting.GRAY));
        tooltipCallback.accept((Component)Component.translatable((String)"tooltip.alloy_forgery.fuel_capacity", (Object[])new Object[]{this.fuelCapacity()}).withStyle(ChatFormatting.GRAY));
    }

    public String toString() {
        return "ForgeTier[id: " + String.valueOf(this.id) + ", value: " + this.value + ", speedMultiplier: " + this.speedMultiplier + ", fuelConsumptionMultiplier: " + this.fuelConsumptionMultiplier + ", fuelCapacity: " + this.fuelCapacity + "]";
    }
}

