/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.forges;

import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.forges.ForgeDefinition;
import io.wispforest.alloyforgery.forges.ForgeTier;
import io.wispforest.alloyforgery.networking.TierDataSync;
import io.wispforest.alloyforgery.utils.data.EndecDataLoader;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ForgeTierDataLoader {
    private static final ForgeTierDataLoader SERVER = new ForgeTierDataLoader();
    private static final ForgeTierDataLoader CLIENT = new ForgeTierDataLoader();
    public static final ResourceLocation TIER_LOADER = AlloyForgery.id("forge_tier");
    public static final ResourceLocation TIER_BINDINGS_LOADER = AlloyForgery.id("forge_tier_bindings");
    private final Map<ResourceLocation, ForgeTier> idToForgeTier = new HashMap<ResourceLocation, ForgeTier>();
    private final Map<ForgeTier, ResourceLocation> forgeTierToId = new IdentityHashMap<ForgeTier, ResourceLocation>();
    private final Map<ResourceLocation, Set<ResourceLocation>> parentTierToChildrenTier = new HashMap<ResourceLocation, Set<ResourceLocation>>();
    private final Map<ResourceLocation, ResourceLocation> forgeDefinitionToTier = new HashMap<ResourceLocation, ResourceLocation>();
    private final Int2ObjectMap<List<ResourceLocation>> tierIndexToTiers = new Int2ObjectLinkedOpenHashMap();

    public static void init() {
        EndecDataLoader.builder("alloy_forge/tier", RawForgeTier.ENDEC).create(TIER_LOADER, PackType.SERVER_DATA, (data, manager, profiler) -> {
            LinkedHashMap<ResourceLocation, Map> waitingChildrenTiers = new LinkedHashMap<ResourceLocation, Map>();
            data.forEach((identifier, rawForgeTier) -> {
                boolean wasAdded = SERVER.registerTier((ResourceLocation)identifier, (RawForgeTier)rawForgeTier);
                if (!wasAdded) {
                    waitingChildrenTiers.computeIfAbsent((ResourceLocation)identifier, id -> new LinkedHashMap()).put(identifier, rawForgeTier);
                } else {
                    Map<ResourceLocation, RawForgeTier> childrenTiers = waitingChildrenTiers.getOrDefault(identifier, Map.of());
                    childrenTiers.forEach(SERVER::registerTier);
                }
            });
            ForgeDefinition.legacyForgeDefinitionIdToTier.forEach((id, forgeTier) -> SERVER.registerTier(id.withSuffix("_legacy_tier"), (ForgeTier)forgeTier));
            waitingChildrenTiers.forEach((parentId, childrenTiers) -> AlloyForgery.LOGGER.error("Unable to register the given children ForgeTier's as the parent '{}' was never registered: [{}]", parentId, childrenTiers.keySet()));
            SERVER.buildSortedIndexToTiersMap();
        });
        EndecDataLoader.builder("alloy_forge/tier_binding", Endec.map(ResourceLocation::toString, ResourceLocation::tryParse, (Endec)MinecraftEndecs.IDENTIFIER)).create(TIER_BINDINGS_LOADER, PackType.SERVER_DATA, (data, manager, profiler) -> {
            data.values().forEach(bindings -> bindings.forEach(ForgeTierDataLoader.SERVER.forgeDefinitionToTier::putIfAbsent));
            ForgeDefinition.legacyForgeDefinitionIdToTier.keySet().forEach(id -> ForgeTierDataLoader.SERVER.forgeDefinitionToTier.putIfAbsent((ResourceLocation)id, id.withSuffix("_legacy_tier")));
        });
    }

    private void buildSortedIndexToTiersMap() {
        this.tierIndexToTiers.clear();
        this.idToForgeTier.forEach((identifier, forgeTier) -> {
            if (this.parentTierToChildrenTier.containsKey(identifier)) {
                return;
            }
            ((List)this.tierIndexToTiers.computeIfAbsent(forgeTier.value(), value -> new ArrayList())).add(identifier);
        });
        this.tierIndexToTiers.forEach((integer, identifiers) -> identifiers.sort(Comparator.naturalOrder()));
    }

    public static ForgeTierDataLoader getForgeRegistry(boolean isClientSide) {
        return isClientSide ? CLIENT : SERVER;
    }

    @Nullable
    public static ResourceLocation getForgeTierId(boolean isClientSide, ForgeTier forgeTier) {
        return ForgeTierDataLoader.getForgeRegistry((boolean)isClientSide).forgeTierToId.get(forgeTier);
    }

    @Nullable
    public static ForgeTier getForgeTier(boolean isClientSide, ResourceLocation tierId) {
        return ForgeTierDataLoader.getForgeRegistry((boolean)isClientSide).idToForgeTier.get(tierId);
    }

    @Nullable
    public ForgeTier getBoundForgeTier(ResourceLocation forgeDefinitionId) {
        return Optional.of(forgeDefinitionId).map(this.forgeDefinitionToTier::get).map(this.idToForgeTier::get).orElse(null);
    }

    public Map<ResourceLocation, ForgeTier> idToForgeTier() {
        return Collections.unmodifiableMap(this.idToForgeTier);
    }

    public Map<ForgeTier, ResourceLocation> forgeTierToId() {
        return Collections.unmodifiableMap(this.forgeTierToId);
    }

    public Map<ResourceLocation, ResourceLocation> forgeDefinitionToTier() {
        return Collections.unmodifiableMap(this.forgeDefinitionToTier);
    }

    public ForgeTier getPrimaryTierOrDefault(ForgeTier tier) {
        ForgeTier primaryTier = this.getPrimaryTier(tier.value());
        return primaryTier != null ? primaryTier : tier;
    }

    public ForgeTier getPrimaryTier(int tierValue) {
        List possibleTiers = (List)this.tierIndexToTiers.get(tierValue);
        if (possibleTiers == null || possibleTiers.isEmpty()) {
            return null;
        }
        return this.idToForgeTier.get(possibleTiers.getFirst());
    }

    @ApiStatus.Internal
    public void setTierData(Map<ResourceLocation, ForgeTier> idToForgeTier, Map<ResourceLocation, ResourceLocation> forgeDefinitionToTier) {
        this.forgeDefinitionToTier.clear();
        this.forgeDefinitionToTier.putAll(forgeDefinitionToTier);
        this.idToForgeTier.clear();
        this.idToForgeTier.putAll(idToForgeTier);
        this.forgeTierToId.clear();
        idToForgeTier.forEach((identifier, forgeTier) -> this.forgeTierToId.put((ForgeTier)forgeTier, (ResourceLocation)identifier));
        CLIENT.buildSortedIndexToTiersMap();
    }

    public static TierDataSync createSyncPacket() {
        return new TierDataSync(SERVER.idToForgeTier(), SERVER.forgeDefinitionToTier());
    }

    private boolean registerTier(ResourceLocation id, RawForgeTier tier) {
        Optional<ForgeTier> parentTier;
        ResourceLocation parentId = tier.parentIdentifier().orElse(null);
        Optional<ForgeTier> optional = parentTier = parentId != null ? Optional.ofNullable(ForgeTierDataLoader.SERVER.idToForgeTier.get(parentId)) : Optional.empty();
        if (parentId != null) {
            this.parentTierToChildrenTier.computeIfAbsent(parentId, identifier -> new HashSet()).add(id);
        } else {
            this.parentTierToChildrenTier.computeIfAbsent(id, identifier -> new HashSet());
        }
        if (parentId != null && parentTier.isEmpty()) {
            return false;
        }
        this.registerTier(id, tier.buildTier(id, parentTier));
        return true;
    }

    private void registerTier(ResourceLocation id, ForgeTier tier) {
        if (ForgeTierDataLoader.SERVER.idToForgeTier.containsKey(id)) {
            return;
        }
        ForgeTierDataLoader.SERVER.idToForgeTier.put(id, tier);
        ForgeTierDataLoader.SERVER.forgeTierToId.put(tier, id);
    }

    public record RawForgeTier(Optional<ResourceLocation> parentIdentifier, Optional<Integer> value, Optional<Float> speedMultiplier, Optional<Float> fuelConsumptionMultiplier, Optional<Integer> fuelCapacity) {
        public static final Endec<RawForgeTier> ENDEC = StructEndecBuilder.of(RawForgeTier.optionalFieldOf(MinecraftEndecs.IDENTIFIER.optionalOf(), "parent_tier", RawForgeTier::parentIdentifier), RawForgeTier.optionalFieldOf(Endec.INT.optionalOf(), "tier", RawForgeTier::value), RawForgeTier.optionalFieldOf(Endec.FLOAT.optionalOf(), "speed_multiplier", RawForgeTier::speedMultiplier), RawForgeTier.optionalFieldOf(Endec.FLOAT.optionalOf(), "fuel_consumption_multiplier", RawForgeTier::fuelConsumptionMultiplier), RawForgeTier.optionalFieldOf(Endec.INT.optionalOf(), "fuel_capacity", RawForgeTier::fuelCapacity), RawForgeTier::new);

        private static <T, S> StructField<S, Optional<T>> optionalFieldOf(Endec<Optional<T>> endec, String name, Function<S, Optional<T>> getter) {
            return new StructField(name, endec, getter, Optional::empty);
        }

        public ForgeTier buildTier(ResourceLocation id, Optional<ForgeTier> parentTier) {
            Float speedMultiplierValue = this.speedMultiplier().or(() -> parentTier.map(ForgeTier::speedMultiplier)).orElse(Float.valueOf(1.0f));
            return new ForgeTier(id, (int)this.value().or(() -> parentTier.map(ForgeTier::value)).orElse(1), speedMultiplierValue.floatValue(), this.fuelConsumptionMultiplier().or(() -> parentTier.map(ForgeTier::fuelConsumptionMultiplier)).orElse(speedMultiplierValue).floatValue(), this.fuelCapacity().or(() -> parentTier.map(ForgeTier::fuelCapacity)).orElse(48000));
        }
    }
}

