/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.neoforge;

import io.wispforest.alloyforgery.neoforge.api.SingleVariantDropletStorage;
import io.wispforest.alloyforgery.utils.FluidStorage;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public final class FluidHolderImpl
extends SingleVariantDropletStorage<FluidResource>
implements FluidStorage {
    private final Runnable onCommitAction;

    public FluidHolderImpl(Runnable onCommitAction) {
        this.onCommitAction = onCommitAction;
    }

    @Override
    protected FluidResource getBlankVariant() {
        return FluidResource.EMPTY;
    }

    @Override
    protected long getCapacity(FluidResource variant) {
        return 81081L;
    }

    @Override
    protected void onFinalCommit() {
        this.onCommitAction.run();
    }

    @Override
    protected boolean canInsert(FluidResource variant) {
        return variant.is((Object)Fluids.LAVA);
    }

    @Override
    protected boolean canExtract(FluidResource variant) {
        return false;
    }

    @Override
    public long extractDroplets(FluidResource extractedVariant, long maxAmount, TransactionContext transaction) {
        return 0L;
    }

    @Override
    public int extract(int i, FluidResource extractedVariant, int maxAmount, TransactionContext transaction) {
        return 0;
    }

    @Override
    public void readData(ValueInput data) {
        this.amount = data.getLongOr("Amount", 0L);
        this.variant = (Resource)data.read("Variant", FluidResource.OPTIONAL_CODEC).orElse(FluidResource.EMPTY);
    }

    @Override
    public void writeData(ValueOutput data) {
        data.putLong("Amount", this.amount);
        data.store("Variant", FluidResource.OPTIONAL_CODEC, (Object)((FluidResource)this.variant));
    }

    @Override
    public float fullnessAmount() {
        return (float)this.amount / 81000.0f;
    }

    @Override
    public long getFluidAmountInDroplets() {
        return this.amount;
    }

    @Override
    public long setFluidAmountInDroplets(long amount) {
        long cappedAmount = Math.min(amount, this.getCapacity());
        long spilledAmount = amount - cappedAmount;
        this.amount = Math.min(amount, this.getCapacity());
        return spilledAmount <= 0L ? 0L : spilledAmount;
    }
}

