/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonSyntaxException;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.block.ForgeControllerBlockEntity;
import io.wispforest.alloyforgery.forges.ForgeTier;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipeInput;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipeSerializer;
import io.wispforest.alloyforgery.recipe.RawAlloyForgeRecipe;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.util.RecipeRemainderStorage;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class AlloyForgeRecipe
implements Recipe<AlloyForgeRecipeInput> {
    private static final Map<Item, ItemStack> GLOBAL_REMAINDERS = new HashMap<Item, ItemStack>();
    private static final List<Integer> INPUT_SLOT_INDICES = IntStream.rangeClosed(0, 9).boxed().toList();
    public static final Map<AlloyForgeRecipe, PendingRecipeData> PENDING_RECIPES = new HashMap<AlloyForgeRecipe, PendingRecipeData>();
    public final Optional<RawAlloyForgeRecipe> rawRecipeData;
    private Optional<ResourceLocation> secondaryID = Optional.empty();
    private final Map<Ingredient, Integer> inputs;
    private ItemStack output;
    private final int minForgeTier;
    private final int fuelPerTick;
    private ImmutableMap<OverrideRange, ItemStack> tierOverrides;
    @Nullable
    private PlacementInfo ingredientPlacement;

    public AlloyForgeRecipe(Optional<RawAlloyForgeRecipe> rawRecipeData, Map<Ingredient, Integer> inputs, ItemStack output, int minForgeTier, int fuelPerTick, Map<OverrideRange, ItemStack> overrides) {
        this.rawRecipeData = rawRecipeData;
        this.inputs = inputs;
        this.output = output;
        this.minForgeTier = minForgeTier;
        this.fuelPerTick = fuelPerTick;
        this.tierOverrides = ImmutableMap.copyOf(overrides);
    }

    public AlloyForgeRecipe(Map<Ingredient, Integer> inputs, ItemStack output, int minForgeTier, int fuelPerTick, Map<OverrideRange, ItemStack> overrides, Optional<ResourceLocation> secondaryID) {
        this(Optional.empty(), inputs, output, minForgeTier, fuelPerTick, overrides);
        this.secondaryID = secondaryID;
    }

    public Optional<ResourceLocation> secondaryID() {
        return this.secondaryID;
    }

    public void finishRecipe(HolderGetter.Provider registryLookup, PendingRecipeData pendingData, Function<AlloyForgeRecipe, ResourceLocation> lookup) {
        if (pendingData.defaultTag() != null) {
            Optional itemEntryList = registryLookup.lookupOrThrow(Registries.ITEM).get((TagKey)pendingData.defaultTag().getA());
            itemEntryList.ifPresentOrElse(registryEntries -> {
                this.output = ((Item)registryEntries.get(0).value()).getDefaultInstance();
                this.output.setCount(((Integer)pendingData.defaultTag().getB()).intValue());
            }, () -> {
                throw new InvalidTagException("Default tag " + String.valueOf(((TagKey)pendingData.defaultTag().getA()).location()) + " of recipe " + String.valueOf(lookup.apply(this)) + " must not be empty");
            });
        }
        ImmutableMap.Builder overrides = ImmutableMap.builder();
        pendingData.unfinishedTierOverrides().forEach((range, override) -> {
            if (override.isCountOnly()) {
                ItemStack stack = this.output.copy();
                stack.setCount(override.count());
                if (!override.components().isEmpty()) {
                    stack.applyComponentsAndValidate(override.components());
                }
                overrides.put(range, (Object)stack);
            } else {
                overrides.put(range, (Object)override.stack());
            }
        });
        this.tierOverrides = overrides.build();
    }

    public static void addRemainders(Map<Item, ItemStack> remainders) {
        GLOBAL_REMAINDERS.putAll(remainders);
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(AlloyForgeRecipeInput input, Level world) {
        return this.tryBind(input) != null;
    }

    public Int2IntMap tryBind(AlloyForgeRecipeInput input) {
        ConcurrentLinkedQueue<Integer> indices = new ConcurrentLinkedQueue<Integer>(INPUT_SLOT_INDICES);
        Int2IntLinkedOpenHashMap boundSlots = new Int2IntLinkedOpenHashMap();
        for (Map.Entry<Ingredient, Integer> ingredient : this.inputs.entrySet()) {
            int remaining = ingredient.getValue();
            for (int index : indices) {
                ItemStack stack = input.getItem(index);
                if (!ingredient.getKey().test(stack)) continue;
                boundSlots.put(index, Math.min(stack.getCount(), remaining));
                indices.remove(index);
                if ((remaining -= stack.getCount()) > 0) continue;
                break;
            }
            if (remaining <= 0) continue;
            return null;
        }
        Iterator<Object> iterator = indices.iterator();
        block2: while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            ItemStack stack = input.getItem(index);
            if (stack.isEmpty()) continue;
            for (Ingredient ingredient : this.inputs.keySet()) {
                if (!ingredient.test(stack)) continue;
                continue block2;
            }
            return null;
        }
        return boundSlots;
    }

    public PlacementInfo placementInfo() {
        if (this.ingredientPlacement == null) {
            this.ingredientPlacement = PlacementInfo.createFromOptionals(this.getIngredientsMap().keySet().stream().map(Optional::of).toList());
        }
        return this.ingredientPlacement;
    }

    public Map<Ingredient, Integer> getIngredientsMap() {
        return this.inputs;
    }

    public ItemStack craft(AlloyForgeRecipeInput input, HolderLookup.Provider lookup) {
        ItemStack itemStack;
        Container container = input.inventory();
        if (container instanceof ForgeControllerBlockEntity) {
            ForgeControllerBlockEntity controller = (ForgeControllerBlockEntity)container;
            itemStack = this.getResult(controller.forgeTier().value());
        } else {
            itemStack = this.getBaseResult();
        }
        return itemStack;
    }

    public void consumeIngredients(AlloyForgeRecipeInput input) {
        Container inventory = input.inventory();
        this.tryBind(input).forEach((arg_0, arg_1) -> ((Container)inventory).removeItem(arg_0, arg_1));
    }

    @Nullable
    public static NonNullList<ItemStack> gatherRemainders(RecipeHolder<AlloyForgeRecipe> recipeEntry, AlloyForgeRecipeInput input) {
        Map owoRemainders;
        ResourceLocation id = recipeEntry.id().location();
        AlloyForgeRecipe recipe = (AlloyForgeRecipe)recipeEntry.value();
        NonNullList remainders = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        Map map = owoRemainders = RecipeRemainderStorage.has((ResourceLocation)id) ? RecipeRemainderStorage.get((ResourceLocation)id) : Map.of();
        if (owoRemainders.isEmpty() && GLOBAL_REMAINDERS.isEmpty()) {
            return null;
        }
        boolean setAnyRemainders = false;
        IntIterator intIterator = recipe.tryBind(input).keySet().iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            Item item = input.getItem(i).getItem();
            if (!owoRemainders.isEmpty()) {
                if (!owoRemainders.containsKey(item)) continue;
                remainders.set(i, (Object)((ItemStack)owoRemainders.get(item)).copy());
                setAnyRemainders = true;
                continue;
            }
            if (!GLOBAL_REMAINDERS.containsKey(item)) continue;
            remainders.set(i, (Object)GLOBAL_REMAINDERS.get(item).copy());
            setAnyRemainders = true;
        }
        return setAnyRemainders ? remainders : null;
    }

    @ApiStatus.Internal
    public ItemStack getBaseResult() {
        return this.output.copy();
    }

    public ItemStack getResult(int forgeTier) {
        ItemStack stack = ((ItemStack)this.tierOverrides.getOrDefault(this.tierOverrides.keySet().stream().filter(overrideRange -> overrideRange.test(forgeTier)).findAny().orElse(null), (Object)this.output)).copy();
        if (stack.getItem() == Items.AIR) {
            int stackCount = stack.getCount();
            stack = this.output.copy();
            stack.setCount(stackCount);
        }
        return stack;
    }

    public RecipeSerializer<? extends Recipe<AlloyForgeRecipeInput>> getSerializer() {
        return AlloyForgeRecipeSerializer.INSTANCE;
    }

    public RecipeType<? extends Recipe<AlloyForgeRecipeInput>> getType() {
        return Type.INSTANCE;
    }

    public RecipeBookCategory recipeBookCategory() {
        return null;
    }

    public int getMinForgeTier() {
        return this.minForgeTier;
    }

    public int getFuelPerTick() {
        return this.fuelPerTick;
    }

    public ImmutableMap<OverrideRange, ItemStack> getTierOverrides() {
        return this.tierOverrides;
    }

    public record PendingRecipeData(@Nullable Tuple<TagKey<Item>, Integer> defaultTag, Map<OverrideRange, PendingOverride> unfinishedTierOverrides) {
    }

    public static class Type
    implements RecipeType<AlloyForgeRecipe> {
        public static final ResourceLocation ID = AlloyForgery.id("forging");
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }

    public record OverrideRange(int lowerBound, int upperBound) {
        public static Endec<OverrideRange> OVERRIDE_RANGE = StructEndecBuilder.of((StructField)Endec.INT.fieldOf("lowerBound", OverrideRange::lowerBound), (StructField)Endec.INT.fieldOf("upperBound", OverrideRange::upperBound), OverrideRange::new);

        public OverrideRange(int lowerBound) {
            this(lowerBound, -1);
        }

        public boolean test(int value) {
            return value >= this.lowerBound && (this.upperBound == -1 || value <= this.upperBound);
        }

        public static OverrideRange fromString(String s) {
            OverrideRange overrideRange;
            if (s.matches("\\d+\\+")) {
                overrideRange = new OverrideRange(Integer.parseInt(s.substring(0, s.length() - 1)));
            } else if (s.matches("\\d+ to \\d+")) {
                overrideRange = new OverrideRange(Integer.parseInt(s.substring(0, s.indexOf(" "))), Integer.parseInt(s.substring(s.lastIndexOf(" ") + 1, s.length())));
            } else if (s.matches("\\d+")) {
                overrideRange = new OverrideRange(Integer.parseInt(s), Integer.parseInt(s));
            } else {
                throw new JsonSyntaxException("Invalid override range token: " + s);
            }
            return overrideRange;
        }

        public Component toText(boolean isClientSide) {
            Component lowerTierName = ForgeTier.toName(isClientSide, this.lowerBound);
            if (this.upperBound != this.lowerBound) {
                if (this.upperBound == -1) {
                    return Component.translatable((String)"tooltip.alloy_forgery.override_range.greater_or_equal_to", (Object[])new Object[]{lowerTierName});
                }
                Character[] to = (Character[])" to ".chars().mapToObj(value -> Character.valueOf((char)value)).toArray(Character[]::new);
                Component upperTierName = ForgeTier.toName(isClientSide, this.lowerBound);
                return Component.translatable((String)"tooltip.alloy_forgery.override_range.range", (Object[])new Object[]{lowerTierName, upperTierName});
            }
            return Component.translatable((String)"tooltip.alloy_forgery.override_range.equal_to", (Object[])new Object[]{lowerTierName});
        }

        @Override
        public String toString() {
            String outString = String.valueOf(this.lowerBound);
            Stream<Character> chars = outString.chars().mapToObj(value -> Character.valueOf((char)value));
            if (this.upperBound != this.lowerBound) {
                if (this.upperBound == -1) {
                    chars = Stream.concat(chars, Stream.of(Character.valueOf('+')));
                } else {
                    Character[] to = (Character[])" to ".chars().mapToObj(value -> Character.valueOf((char)value)).toArray(Character[]::new);
                    chars = Stream.concat(chars, Arrays.stream(to));
                    Character[] bound = (Character[])String.valueOf(this.upperBound).chars().mapToObj(value -> Character.valueOf((char)value)).toArray(Character[]::new);
                    chars = Stream.concat(chars, Arrays.stream(bound));
                }
            }
            StringBuffer output = new StringBuffer();
            chars.forEach(character -> output.append(character));
            return output.toString();
        }
    }

    public record PendingOverride(@Nullable Item item, int count, DataComponentPatch components) {
        public boolean isCountOnly() {
            return this.item == null;
        }

        public static PendingOverride onlyCount(int count) {
            return new PendingOverride(null, count, DataComponentPatch.EMPTY);
        }

        public static PendingOverride ofItem(Item item, int count) {
            return new PendingOverride(item, count, DataComponentPatch.EMPTY);
        }

        public ItemStack stack() {
            ItemStack stack = new ItemStack((ItemLike)this.item, this.count);
            stack.applyComponentsAndValidate(this.components);
            return new ItemStack((ItemLike)this.item, this.count);
        }
    }

    public static class InvalidTagException
    extends RuntimeException {
        public InvalidTagException(String message) {
            super(message);
        }
    }
}

