/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.Strictness;
import com.mojang.logging.LogUtils;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.data.RecipeTagLoader;
import io.wispforest.alloyforgery.mixin.SingleStackRecipeAccessor;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipe;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipeSerializer;
import io.wispforest.alloyforgery.utils.RecipeInjector;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.format.gson.GsonDeserializer;
import io.wispforest.owo.serialization.RegistriesAttribute;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.slf4j.Logger;

public class BlastFurnaceRecipeAdapter
implements RecipeInjector.AddRecipes {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).create();
    private static final TagKey<Item> DUSTS_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dusts"));
    public static final ResourceLocation BLACKLISTED_BLASTING_RECIPES = AlloyForgery.id("blacklisted_blasting_recipes");
    public static final ResourceLocation BLACKLISTED_INCREASED_OUTPUT = AlloyForgery.id("blacklisted_increased_blasting_outputs");
    private static final String ExtraRecipe = "ewogICJfY29tbWVudCI6ICJUaGlzIHJlY2lwZSBpcyBmb3IgYSBmcmllbmQgYW5kIGNvbnRhaW5zIG5vdGhpbmcgbWFsaWNpb3VzIHVubGVzcyBidXJudCBtZWF0IGlzIHNhZCBmb3IgeW91LiIsCiAgInR5cGUiOiAiYWxsb3lfZm9yZ2VyeTpmb3JnaW5nIiwKICAiaW5wdXRzIjogWwogICAgewogICAgICAiaW5ncmVkaWVudCI6ICIjbWluZWNyYWZ0Om1lYXQiLAogICAgICAiY291bnQiOiA0CiAgICB9CiAgXSwKICAib3V0cHV0IjogewogICAgIml0ZW0iOiAibWluZWNyYWZ0OmNoYXJjb2FsIiwKICAgICJjb3VudCI6IDEsCiAgICAiY29tcG9uZW50cyI6IHsKICAgICAgImN1c3RvbV9uYW1lIjogIlt7XCJ0ZXh0XCI6XCJDb29rZWRcIixcIml0YWxpY1wiOnRydWV9LCBcIiBcIiwge1widGV4dFwiOlwiU3RlYWtcIixcImNsaWNrRXZlbnRcIjp7XCJhY3Rpb25cIjpcIm9wZW5fdXJsXCIsXCJ2YWx1ZVwiOlwiaHR0cHM6Ly93d3cueW91dHViZS5jb20vd2F0Y2g/dj1kUXc0dzlXZ1hjUVwifSxcInN0cmlrZXRocm91Z2hcIjp0cnVlfV0iCiAgICB9CiAgfSwKICAib3ZlcnJpZGVzIjogewogICAgIjMiOiB7CiAgICAgICJpdGVtIjogIm1pbmVjcmFmdDpjaGFyY29hbCIsCiAgICAgICJjb3VudCI6IDIsCiAgICAgICJjb21wb25lbnRzIjogewogICAgICAgICJjdXN0b21fbmFtZSI6ICJbe1widGV4dFwiOlwiQ29va2VkXCIsXCJpdGFsaWNcIjp0cnVlfSwgXCIgXCIsIHtcInRleHRcIjpcIlN0ZWFrXCIsXCJjbGlja0V2ZW50XCI6e1wiYWN0aW9uXCI6XCJvcGVuX3VybFwiLFwidmFsdWVcIjpcImh0dHBzOi8vd3d3LnlvdXR1YmUuY29tL3dhdGNoP3Y9ZFF3NHc5V2dYY1FcIn0sXCJzdHJpa2V0aHJvdWdoXCI6dHJ1ZX1dIgogICAgICB9CiAgICB9LAogICAgIjQiOiB7CiAgICAgICJpdGVtIjogIm1pbmVjcmFmdDpwb2lzb25vdXNfcG90YXRvIiwKICAgICAgImNvdW50IjogMSwKICAgICAgImNvbXBvbmVudHMiOiB7CiAgICAgICAgImN1c3RvbV9uYW1lIjogIltcIm/PiW8sIGhvdyBkaWQgdGhpcyBoYXBwZW4/XCJdIgogICAgICB9CiAgICB9CiAgfSwKICAibWluX2ZvcmdlX3RpZXIiOiAyLAogICJmdWVsX3Blcl90aWNrIjogMjAKfQ==";

    @Override
    public void addRecipes(RecipeInjector instance) {
        if (!AlloyForgery.CONFIG.allowBlastingFurnaceAdaption()) {
            return;
        }
        RecipeManager manager = instance.manager();
        Collection<RecipeHolder<AlloyForgeRecipe>> alloyForgeryRecipes = instance.getAllOfType(AlloyForgeRecipe.Type.INSTANCE);
        for (RecipeHolder recipeEntry : instance.getAllOfType(RecipeType.BLASTING)) {
            BlastingRecipe recipe = (BlastingRecipe)recipeEntry.value();
            if (!BlastFurnaceRecipeAdapter.isUniqueRecipe(instance, alloyForgeryRecipes, recipe) || RecipeTagLoader.isWithinTag(false, BLACKLISTED_BLASTING_RECIPES, recipeEntry)) continue;
            ResourceLocation secondaryID = recipeEntry.id().location();
            String path = secondaryID.getPath();
            if (path.contains("blasting")) {
                path = path.replace("blasting", "forging");
            }
            ItemStack mainOutput = ((SingleStackRecipeAccessor)recipe).result().copy();
            mainOutput.setCount(AlloyForgery.CONFIG.baseInputAmount());
            ImmutableMap.Builder extraOutput = ImmutableMap.builder();
            if (AlloyForgery.CONFIG.allowHigherTierOutput() && !RecipeTagLoader.isWithinTag(false, BLACKLISTED_INCREASED_OUTPUT, recipeEntry) && !BlastFurnaceRecipeAdapter.isDustRecipe(instance, recipeEntry)) {
                ItemStack increasedOutput = mainOutput.copy();
                increasedOutput.grow(AlloyForgery.CONFIG.higherTierOutputIncrease());
                extraOutput.put((Object)new AlloyForgeRecipe.OverrideRange(3), (Object)increasedOutput);
            }
            ResourceLocation recipeId = AlloyForgery.id(path);
            AlloyForgeRecipe convertRecipe = new AlloyForgeRecipe(Map.of((Ingredient)recipe.placementInfo().ingredients().get(0), AlloyForgery.CONFIG.baseInputAmount()), mainOutput, 1, Math.round(BlastFurnaceRecipeAdapter.getFuelPerTick(recipe)), (Map<AlloyForgeRecipe.OverrideRange, ItemStack>)extraOutput.build(), Optional.of(secondaryID));
            instance.addRecipe(recipeId, convertRecipe);
        }
        try {
            AlloyForgeRecipe funny = (AlloyForgeRecipe)AlloyForgeRecipeSerializer.RECIPE_ENDEC.decodeFully(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.fromCachedInfoGetter((RegistryOps.HolderLookupAdapter)new RegistryOps.HolderLookupAdapter(instance.lookup()))}), GsonDeserializer::of, (Object)((JsonElement)GSON.fromJson(new String(Base64.getDecoder().decode(ExtraRecipe)), JsonElement.class)));
            instance.addRecipe(AlloyForgery.id("super_duper_fun_recipe"), funny);
        }
        catch (Throwable e) {
            LOGGER.error("{} recipe had a issue!", (Object)AlloyForgery.id("super_duper_fun_recipe"), (Object)e);
        }
    }

    private static float getFuelPerTick(BlastingRecipe recipe) {
        return (float)recipe.cookingTime() / 200.0f * 10.0f;
    }

    private static boolean isUniqueRecipe(RecipeInjector instance, Collection<RecipeHolder<AlloyForgeRecipe>> alloyForgeryRecipes, Recipe<?> blastRecipe) {
        List<ItemStack> stacks = instance.getStacks((Ingredient)blastRecipe.placementInfo().ingredients().get(0));
        List<RecipeHolder> matchedRecipes = alloyForgeryRecipes.stream().filter(recipeEntry -> {
            AlloyForgeRecipe recipe = (AlloyForgeRecipe)recipeEntry.value();
            if (recipe.getIngredientsMap().size() > 1) {
                return false;
            }
            for (ItemStack stack : stacks) {
                if (!((Ingredient)recipe.placementInfo().ingredients().get(0)).test(stack)) continue;
                return true;
            }
            return false;
        }).toList();
        return matchedRecipes.isEmpty();
    }

    private static boolean isDustRecipe(RecipeInjector instance, RecipeHolder<BlastingRecipe> blastingRecipeEntry) {
        if (blastingRecipeEntry.id().location().getPath().contains("dust")) {
            return true;
        }
        BlastingRecipe blastRecipe = (BlastingRecipe)blastingRecipeEntry.value();
        List<ItemStack> stacks = instance.getStacks((Ingredient)blastRecipe.placementInfo().ingredients().get(0));
        for (ItemStack stack : stacks) {
            if (stack.is(DUSTS_TAG)) {
                return true;
            }
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            if (!id.getPath().contains("dust")) continue;
            return true;
        }
        return false;
    }
}

