package io.wispforest.alloyforgery.block;

import java.util.List;
import net.minecraft.world.item.ItemStack;

public class ItemStackComparisonUtil {

    /**
     * Compares two lists of item stacks and returns true if they are different from one another
     */
    public static boolean itemsChanged(List<ItemStack> list1, List<ItemStack> list2) {
        if (list1.size() != list2.size()) return true;

        for (int i = 0; i < list1.size(); i++) {
            var stack1 = list1.get(i);
            var stack2 = list2.get(i);

            if (!ItemStack.matches(stack1, stack2)) return true;
        }

        return false;
    }
}
