package io.wispforest.alloyforgery.client;

import io.wispforest.owo.ui.component.SpriteComponent;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;

public class FixedSpriteComponent extends SpriteComponent {
    protected FixedSpriteComponent(TextureAtlasSprite sprite) {
        super(sprite);
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        super.draw(context, mouseX, mouseY, partialTicks, delta);
        context.flush();
    }

    public static FixedSpriteComponent fixedSprite(Material spriteId) {
        return new FixedSpriteComponent(
            spriteId.atlasLocation().equals(ResourceLocation.parse("textures/atlas/gui.png"))
                ? Minecraft.getInstance().getGuiSprites().getSprite(spriteId.texture())
                : spriteId.sprite()
        );
    }
}
