package io.wispforest.alloyforgery.mixin.registry;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import io.wispforest.alloyforgery.compat.LegacyIdMappings;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.resources.ResourceLocation;

@Mixin(DefaultedMappedRegistry.class)
public abstract class DefaultedRegistryMixin {
    @ModifyVariable(at = @At("HEAD"), method = "get(Lnet/minecraft/util/Identifier;)Ljava/lang/Object;", ordinal = 0, argsOnly = true)
    private ResourceLocation fixMissingFromRegistry(@Nullable ResourceLocation id) {
        return LegacyIdMappings.remap(id);
    }
}
