package io.wispforest.alloyforgery.pond;

import io.wispforest.alloyforgery.data.RecipeTagLoader;
import io.wispforest.alloyforgery.mixin.RecipeEntryMixin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;

/**
 * Helper interface injected into {@link Recipe} through {@link RecipeEntryMixin}
 * to implement Tag check call within {@link RecipeTagLoader}
 */
public interface RecipeTagHelper {

    default boolean isIn(ResourceLocation tag) {
        throw new UnsupportedOperationException("RecipeTagHelper 'isIn' method not implememnted!");
    }
}
