/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery;

import com.google.common.reflect.Reflection;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import io.wispforest.alloyforgery.AlloyForgeScreenHandler;
import io.wispforest.alloyforgery.AlloyForgeryItemGroup;
import io.wispforest.alloyforgery.block.ForgeControllerBlockEntity;
import io.wispforest.alloyforgery.client.BlockEntityLocation;
import io.wispforest.alloyforgery.compat.AlloyForgeryConfig;
import io.wispforest.alloyforgery.compat.CountedIngredientDisplay;
import io.wispforest.alloyforgery.forges.ForgeDefinition;
import io.wispforest.alloyforgery.forges.ForgeFuelDataLoader;
import io.wispforest.alloyforgery.forges.ForgeTierDataLoader;
import io.wispforest.alloyforgery.networking.AlloyForgeNetworking;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipe;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipeSerializer;
import io.wispforest.alloyforgery.recipe.BlastFurnaceRecipeAdapter;
import io.wispforest.alloyforgery.utils.DataPackEvents;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import io.wispforest.alloyforgery.utils.LoaderPlatformUtils;
import io.wispforest.alloyforgery.utils.RecipeInjector;
import io.wispforest.alloyforgery.utils.data.EndecDataLoader;
import io.wispforest.endec.Endec;
import io.wispforest.owo.particles.ClientParticles;
import io.wispforest.owo.particles.systems.ParticleSystem;
import io.wispforest.owo.particles.systems.ParticleSystemController;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlloyForgery {
    public static final String MOD_ID = "alloy-forgery";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"alloy-forgery");
    public static final boolean DEBUG;
    public static final AlloyForgeryConfig CONFIG;
    private static final ParticleSystemController CONTROLLER;
    public static final ParticleSystem<Direction> FORGE_PARTICLES;

    public static void init() {
        AlloyForgeNetworking.init();
        Endec remaindersEndec = Endec.map(item -> BuiltInRegistries.ITEM.getKey(item).toString(), id -> (Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.parse((String)id)), (Endec)CodecUtils.eitherEndec((Endec)CodecUtils.toEndec((Codec)ItemStack.STRICT_CODEC), (Endec)MinecraftEndecs.ofRegistry((Registry)BuiltInRegistries.ITEM)).xmap(either -> (ItemStack)Either.unwrap((Either)either.mapRight(Item::getDefaultInstance)), Either::left));
        EndecDataLoader.builder("forge_remainder", remaindersEndec).create(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"forge_remainder"), PackType.SERVER_DATA, (data, manager, profiler) -> data.values().forEach(AlloyForgeRecipe::addRemainders));
        ForgeFuelDataLoader.init();
        ForgeTierDataLoader.init();
        Reflection.initialize((Class[])new Class[]{ForgeFuelDataLoader.class});
        RecipeInjector.ADD_RECIPES.register((Object)new BlastFurnaceRecipeAdapter());
        DataPackEvents.BEFORE_SYNC.register(RecipeInjector::injectRecipes);
        ForgeDefinition.injectRecipeAdditions();
    }

    public static void registerScreenHandlerType() {
        AlloyForgeScreenHandler.ALLOY_FORGE_SCREEN_HANDLER_TYPE = (MenuType)Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)AlloyForgery.id("alloy_forge"), GeneralPlatformUtils.INSTANCE.createScreenHandlerType((syncId, inventory, location) -> new AlloyForgeScreenHandler(syncId, inventory, location.get(inventory.player, ForgeControllerBlockEntity.FORGE_CONTROLLER_BLOCK_ENTITY)), CodecUtils.toPacketCodec(BlockEntityLocation.ENDEC)));
    }

    public static void registerBlockEntities() {
        ForgeControllerBlockEntity.FORGE_CONTROLLER_BLOCK_ENTITY = (BlockEntityType)Registry.register((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (ResourceLocation)AlloyForgery.id("forge_controller"), GeneralPlatformUtils.INSTANCE.createBlockEntityType(ForgeControllerBlockEntity::new));
    }

    public static void registerRecipeTypes() {
        Registry.register((Registry)BuiltInRegistries.RECIPE_TYPE, (ResourceLocation)AlloyForgeRecipe.Type.ID, (Object)AlloyForgeRecipe.Type.INSTANCE);
    }

    public static void registerRecipeSerializers() {
        Registry.register((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (ResourceLocation)AlloyForgeRecipe.Type.ID, (Object)((Object)AlloyForgeRecipeSerializer.INSTANCE));
    }

    public static void registerSlotDisplays() {
        Registry.register((Registry)BuiltInRegistries.SLOT_DISPLAY, (ResourceLocation)AlloyForgery.id("counted_ingredient"), CountedIngredientDisplay.SERIALIZER);
    }

    public static void registerItemGroup() {
        AlloyForgeryItemGroup.GROUP.initialize();
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static String translationKey(String suffix) {
        return "alloy-forgery." + suffix;
    }

    public static MutableComponent translation(String prefix, String suffix, Object ... args) {
        return Component.translatable((String)(prefix + ".alloy-forgery." + suffix), (Object[])args);
    }

    public static MutableComponent tooltipTranslation(String suffix, Object ... args) {
        return AlloyForgery.translation("tooltip", suffix, args);
    }

    static {
        boolean debug = LoaderPlatformUtils.INSTANCE.isDevelopmentEnvironment();
        if (System.getProperty("alloy-forgery.debug") != null) {
            debug = Boolean.getBoolean("alloy-forgery.debug");
        }
        DEBUG = debug;
        CONFIG = AlloyForgeryConfig.createAndLoad();
        CONTROLLER = new ParticleSystemController(AlloyForgery.id("particles"));
        FORGE_PARTICLES = CONTROLLER.register(Direction.class, (world, pos, facing) -> {
            Vec3 particleSide = pos.add(0.5 + (double)facing.getStepX() * 0.515, 0.25, 0.5 + (double)facing.getStepZ() * 0.515);
            ClientParticles.spawnPrecise((ParticleOptions)ParticleTypes.FLAME, (Level)world, (Vec3)particleSide, (double)((double)facing.getStepZ() * 0.65), (double)0.175, (double)((double)facing.getStepX() * 0.65));
            ClientParticles.spawnPrecise((ParticleOptions)ParticleTypes.SMOKE, (Level)world, (Vec3)particleSide, (double)((double)facing.getStepZ() * 0.65), (double)0.175, (double)((double)facing.getStepX() * 0.65));
        });
    }
}

