/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.neoforge;

import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.block.ForgeControllerBlockEntity;
import io.wispforest.alloyforgery.data.RecipeTagLoader;
import io.wispforest.alloyforgery.forges.ForgeDefinition;
import io.wispforest.alloyforgery.forges.ForgeTierDataLoader;
import io.wispforest.alloyforgery.neoforge.utils.NeoforgeGeneralPlatformUtils;
import io.wispforest.alloyforgery.networking.AlloyForgeNetworking;
import io.wispforest.alloyforgery.networking.TierDataSync;
import io.wispforest.alloyforgery.utils.RecipeInjector;
import java.util.Collection;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;

@Mod(value="alloy_forgery")
public class AlloyForgeryNeoforge {
    private static IEventBus MOD_BUS = null;

    public AlloyForgeryNeoforge(IEventBus modBus, Dist dist) {
        MOD_BUS = modBus;
        AlloyForgery.LOGGER.info("alloy-forgery is now loading!");
        NeoForge.EVENT_BUS.addListener(event -> {
            event.addListener(RecipeTagLoader.ID, (PreparableReloadListener)RecipeTagLoader.INSTANCE);
            NeoforgeGeneralPlatformUtils.registerEndecDataLoaders(new NeoforgeGeneralPlatformUtils.ReloadListenerRegistration(){
                final /* synthetic */ AddServerReloadListenersEvent val$event;
                {
                    this.val$event = addServerReloadListenersEvent;
                }

                @Override
                public PackType getType() {
                    return PackType.SERVER_DATA;
                }

                @Override
                public RegistryAccess getRegistry() {
                    return this.val$event.getRegistryAccess();
                }

                @Override
                public NeoforgeGeneralPlatformUtils.ReloadListenerRegistration addListener(ResourceLocation id, PreparableReloadListener listener) {
                    this.val$event.addListener(id, listener);
                    return this;
                }

                @Override
                public NeoforgeGeneralPlatformUtils.ReloadListenerRegistration addDependency(ResourceLocation id, Collection<ResourceLocation> dependencies) {
                    for (ResourceLocation dependency : dependencies) {
                        this.val$event.addDependency(dependency, id);
                    }
                    return this;
                }
            });
        });
        ForgeDefinition.runDataLoaders();
        modBus.addListener(event -> AlloyForgery.init());
        NeoForge.EVENT_BUS.addListener(event -> RecipeInjector.injectRecipes(event.getServer()));
        modBus.addListener(capabilityEvent -> {
            capabilityEvent.registerBlockEntity(Capabilities.FluidHandler.BLOCK, ForgeControllerBlockEntity.FORGE_CONTROLLER_BLOCK_ENTITY, (blockEntity, context) -> (IFluidHandler)blockEntity.getFluidHolder());
            capabilityEvent.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ForgeControllerBlockEntity.FORGE_CONTROLLER_BLOCK_ENTITY, SidedInvWrapper::new);
        });
        modBus.addListener(event -> {
            event.register(Registries.BLOCK_ENTITY_TYPE, helper -> AlloyForgery.registerBlockEntities());
            event.register(Registries.RECIPE_TYPE, helper -> AlloyForgery.registerRecipeTypes());
            event.register(Registries.RECIPE_SERIALIZER, helper -> AlloyForgery.registerRecipeSerializers());
            event.register(Registries.MENU, helper -> AlloyForgery.registerScreenHandlerType());
            event.register(Registries.SLOT_DISPLAY, helper -> AlloyForgery.registerSlotDisplays());
            event.register(Registries.CREATIVE_MODE_TAB, helper -> AlloyForgery.registerItemGroup());
            event.register(Registries.BLOCK, helper -> NeoforgeGeneralPlatformUtils.handleLoadedEntries());
            event.register(Registries.ITEM, helper -> NeoforgeGeneralPlatformUtils.handleLoadedEntries());
        });
        NeoForge.EVENT_BUS.addListener(event -> {
            TierDataSync packet = ForgeTierDataLoader.createSyncPacket();
            event.getRelevantPlayers().forEach(player -> AlloyForgeNetworking.CHANNEL.serverHandle((Player)player).send((Record)packet));
        });
        this.initEvents();
    }

    public void initEvents() {
        NeoForge.EVENT_BUS.addListener(event -> event.getRelevantPlayers().forEach(RecipeTagLoader.INSTANCE::sendPlayerPacketAfterDataLoad));
        NeoForge.EVENT_BUS.addListener(event -> RecipeTagLoader.INSTANCE.onServerStarted(event.getServer()));
        NeoForge.EVENT_BUS.addListener(event -> RecipeTagLoader.INSTANCE.sendTagPacket((ServerPlayer)event.getEntity()));
    }

    public IEventBus getBus() {
        if (MOD_BUS == null) {
            throw new IllegalStateException("Unable to get the given IEventBus for the following mod: alloy-forgery");
        }
        return MOD_BUS;
    }
}

