/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.neoforge.utils;

import io.netty.buffer.ByteBuf;
import io.wispforest.alloyforgery.block.ForgeControllerBlockEntity;
import io.wispforest.alloyforgery.client.BlockEntityLocation;
import io.wispforest.alloyforgery.data.providers.ResourceConditionHolder;
import io.wispforest.alloyforgery.forges.ForgeRegistry;
import io.wispforest.alloyforgery.neoforge.FluidHolderImpl;
import io.wispforest.alloyforgery.neoforge.data.NeoforgeResourceConditionHolder;
import io.wispforest.alloyforgery.utils.FluidStorage;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import io.wispforest.alloyforgery.utils.data.EndecDataLoader;
import io.wispforest.endec.format.bytebuf.ByteBufSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.IContainerFactory;
import org.jetbrains.annotations.Nullable;

public class NeoforgeGeneralPlatformUtils
implements GeneralPlatformUtils {
    private static final Set<Block> CONTROLLER_BLOCKS = new HashSet<Block>();
    private static final Map<PackType, Map<ResourceLocation, EndecDataLoader<?>>> LOADER_MAP = new HashMap();
    private static boolean isFrozen = true;
    private static final Map<ResourceLocation, ForgeRegistry.EntryHolder> REGISTERED_ENTRIES = new LinkedHashMap<ResourceLocation, ForgeRegistry.EntryHolder>();

    @Override
    public <T extends AbstractContainerMenu, D> MenuType<T> createScreenHandlerType(GeneralPlatformUtils.ExtendedFactory<T, D> factory, StreamCodec<? super RegistryFriendlyByteBuf, D> packetCodec) {
        return new MenuType((MenuType.MenuSupplier)((IContainerFactory)(i, inv, buf) -> factory.create(i, inv, packetCodec.decode((Object)buf))), FeatureFlags.VANILLA_SET);
    }

    @Override
    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(GeneralPlatformUtils.Factory<T> factory) {
        return new BlockEntityType(factory::create, CONTROLLER_BLOCKS);
    }

    @Override
    public void addToBlockEntity(BlockEntityType<ForgeControllerBlockEntity> type, Block ... blocks) {
        if (type != ForgeControllerBlockEntity.FORGE_CONTROLLER_BLOCK_ENTITY) {
            throw new IllegalStateException("UHHHHHHHHHHHHH");
        }
        for (Block block : blocks) {
            CONTROLLER_BLOCKS.add(block);
        }
    }

    @Override
    public boolean interactWithFluidStorage(ForgeControllerBlockEntity controller, Player player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)((IFluidHandler)controller.getFluidHolder()));
    }

    @Override
    public FluidStorage createStorage(ForgeControllerBlockEntity controller) {
        return new FluidHolderImpl(controller::setChanged);
    }

    @Override
    public <I extends RecipeInput, T extends Recipe<I>> Stream<RecipeHolder<T>> getAllMatches(RecipeManager manager, RecipeType<T> type, I input, Level world) {
        return manager.recipeMap().getRecipesFor(type, input, world);
    }

    @Override
    public <I extends RecipeInput, T extends Recipe<I>> Collection<RecipeHolder<T>> getAllOfType(RecipeManager manager, RecipeType<T> type) {
        return manager.recipeMap().byType(type);
    }

    @Override
    public Ingredient createStackIngredient(ItemStack stack) {
        DataComponentMap.Builder builder = DataComponentMap.builder();
        for (Map.Entry entry : stack.getComponentsPatch().entrySet()) {
            NeoforgeGeneralPlatformUtils.addUnsafe(builder, (DataComponentType)entry.getKey(), (Optional)entry.getValue());
        }
        return DataComponentIngredient.of((boolean)false, (DataComponentMap)builder.build(), (Holder[])new Holder[]{stack.getItemHolder()});
    }

    private static <T> void addUnsafe(DataComponentMap.Builder builder, DataComponentType<T> type, Optional<?> data) {
        builder.set(type, data.orElse(null));
    }

    @Override
    public void registerLoader(ResourceLocation id, PackType packType, EndecDataLoader<?> loader, boolean requiresRegistries) {
        Map map = LOADER_MAP.computeIfAbsent(packType, resourceType -> new LinkedHashMap());
        if (map.containsKey(id)) {
            throw new IllegalStateException("Unable to register Data Loader as the given identifier has already been registered: " + String.valueOf(id));
        }
        map.put(id, loader);
    }

    public static void registerEndecDataLoaders(ReloadListenerRegistration registration) {
        LOADER_MAP.getOrDefault(registration.getType(), Map.of()).forEach((identifier, loader) -> {
            if (loader.requiresRegistries()) {
                loader.setupOps((HolderLookup.Provider)registration.getRegistry());
            }
            registration.addListener((ResourceLocation)identifier, (PreparableReloadListener)loader).addDependency((ResourceLocation)identifier, (Collection<ResourceLocation>)loader.getDependencyIds());
        });
    }

    @Override
    public OptionalInt openHandledScreen(Player player, ForgeControllerBlockEntity blockEntity, @Nullable MenuProvider factory) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer.openMenu(factory, registryByteBuf -> BlockEntityLocation.ENDEC.encodeFully(() -> ByteBufSerializer.of((ByteBuf)registryByteBuf), (Object)blockEntity.getExtraScreenData(serverPlayer)));
        }
        return GeneralPlatformUtils.super.openHandledScreen(player, blockEntity, factory);
    }

    @Override
    public ResourceConditionHolder createConditionsHolder() {
        return new NeoforgeResourceConditionHolder(new ArrayList<ICondition>());
    }

    @Override
    public void handleDefinitionEntry(ForgeRegistry.EntryHolder holder) {
        if (isFrozen) {
            REGISTERED_ENTRIES.put(holder.controllerId, holder);
        } else {
            holder.registerBlock();
            holder.registerItem();
        }
    }

    public static void handleLoadedEntries() {
        if (!REGISTERED_ENTRIES.isEmpty()) {
            for (ForgeRegistry.EntryHolder value : REGISTERED_ENTRIES.values()) {
                value.registerBlock();
                value.registerItem();
            }
            REGISTERED_ENTRIES.clear();
        }
        isFrozen = false;
    }

    public static interface ReloadListenerRegistration {
        public PackType getType();

        default public RegistryAccess getRegistry() {
            throw new IllegalStateException("Unable to get DynamicRegistryManager on the Client!");
        }

        public ReloadListenerRegistration addListener(ResourceLocation var1, PreparableReloadListener var2);

        public ReloadListenerRegistration addDependency(ResourceLocation var1, Collection<ResourceLocation> var2);
    }
}

