/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipe;
import io.wispforest.alloyforgery.recipe.CountedIngredient;
import io.wispforest.alloyforgery.recipe.OutputData;
import io.wispforest.alloyforgery.utils.EndecUtils;
import io.wispforest.alloyforgery.utils.LoaderPlatformUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableInt;

public record RawAlloyForgeRecipe(Map<Ingredient, Integer> inputs, OutputData outputData, int minForgeTier, int requiredFuel, Map<AlloyForgeRecipe.OverrideRange, AlloyForgeRecipe.PendingOverride> overrideData) {
    public static Endec<Map<Ingredient, Integer>> INPUTS = CountedIngredient.ENDEC.listOf().xmap(list -> {
        Object2ObjectLinkedOpenHashMap unprocessedData = new Object2ObjectLinkedOpenHashMap();
        for (CountedIngredient countedIngredient : list) {
            Ingredient ingredient2 = countedIngredient.ingredient();
            if (unprocessedData.containsKey((Object)ingredient2) && (AlloyForgery.CONFIG.strictRecipeChecks() || LoaderPlatformUtils.INSTANCE.isDevelopmentEnvironment())) {
                String jsonData = Ingredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ingredient2).result().map(JsonElement::toString).orElse("Error Unknown");
                throw new IllegalStateException("Duplicate Ingredient Entry! Merge all ingredients of [" + jsonData + "] into a single entry and add a count!");
            }
            ((MutableInt)unprocessedData.computeIfAbsent((Object)ingredient2, key -> new MutableInt(0))).add(countedIngredient.count());
        }
        LinkedHashMap data = new LinkedHashMap();
        unprocessedData.forEach((ingredient, mutableInt) -> data.put(ingredient, mutableInt.getValue()));
        return data;
    }, map -> map.entrySet().stream().map(entry -> new CountedIngredient((Ingredient)entry.getKey(), (Integer)entry.getValue())).toList());
    public static Endec<AlloyForgeRecipe.PendingOverride> PENDING_OVERRIDE = StructEndecBuilder.of((StructField)MinecraftEndecs.ofRegistry((Registry)BuiltInRegistries.ITEM).optionalFieldOf("item", AlloyForgeRecipe.PendingOverride::item, () -> null), (StructField)MinecraftEndecs.ofRegistry((Registry)BuiltInRegistries.ITEM).optionalFieldOf("id", orderride -> null, () -> null), (StructField)Endec.INT.fieldOf("count", AlloyForgeRecipe.PendingOverride::count), EndecUtils.optionalFieldOf("components", CodecUtils.toEndec((Codec)DataComponentPatch.CODEC), AlloyForgeRecipe.PendingOverride::components, () -> DataComponentPatch.EMPTY), (item, item2, count, components) -> {
        if (item == null) {
            item = item2;
        }
        return new AlloyForgeRecipe.PendingOverride((Item)item, (int)count, (DataComponentPatch)components);
    });
    public static StructEndec<RawAlloyForgeRecipe> ENDEC = StructEndecBuilder.of((StructField)INPUTS.validate(ingredientToCount -> {
        if (ingredientToCount.isEmpty()) {
            throw new JsonSyntaxException("Inputs cannot be empty");
        }
        if (ingredientToCount.keySet().size() > 10) {
            throw new JsonSyntaxException("Recipe has more than 10 distinct input ingredients");
        }
        if (ingredientToCount.values().stream().mapToInt(integer -> integer).sum() > 640) {
            throw new JsonSyntaxException("Recipe exceeded maximum input item count of 640");
        }
    }).fieldOf("inputs", RawAlloyForgeRecipe::inputs), (StructField)OutputData.ENDEC.fieldOf("output", RawAlloyForgeRecipe::outputData), (StructField)Endec.INT.fieldOf("min_forge_tier", RawAlloyForgeRecipe::minForgeTier), (StructField)Endec.INT.fieldOf("fuel_per_tick", RawAlloyForgeRecipe::requiredFuel), (StructField)PENDING_OVERRIDE.mapOf().xmap(rawData -> {
        LinkedHashMap data = new LinkedHashMap();
        rawData.forEach((s, pendingOverride) -> data.put(AlloyForgeRecipe.OverrideRange.fromString(s), pendingOverride));
        return data;
    }, data -> {
        LinkedHashMap rawData = new LinkedHashMap();
        data.forEach((range, pendingOverride) -> rawData.put(range.toString(), pendingOverride));
        return rawData;
    }).optionalFieldOf("overrides", RawAlloyForgeRecipe::overrideData, HashMap::new), RawAlloyForgeRecipe::new);

    public Tuple<ItemStack, ImmutableMap<AlloyForgeRecipe.OverrideRange, ItemStack>> finalOutputData(Map<AlloyForgeRecipe.OverrideRange, AlloyForgeRecipe.PendingOverride> overridesBuilder) {
        if (this.outputData.outputItem() == null) {
            return new Tuple((Object)ItemStack.EMPTY, (Object)ImmutableMap.of());
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ItemStack outputStack = new ItemStack((ItemLike)this.outputData.outputItem(), this.outputData.count().intValue());
        for (Map.Entry<AlloyForgeRecipe.OverrideRange, AlloyForgeRecipe.PendingOverride> entry : overridesBuilder.entrySet()) {
            ItemStack stack;
            if (entry.getValue().isCountOnly()) {
                stack = outputStack.copy();
                stack.setCount(entry.getValue().count());
            } else {
                stack = entry.getValue().stack();
            }
            if (!entry.getValue().components().isEmpty()) {
                stack.applyComponentsAndValidate(entry.getValue().components());
            }
            builder.put((Object)entry.getKey(), (Object)stack);
        }
        return new Tuple((Object)outputStack, (Object)builder.build());
    }

    public AlloyForgeRecipe generateRecipe() {
        return this.generateRecipe(false);
    }

    public AlloyForgeRecipe generateRecipe(boolean isDataGenerated) {
        Tuple<ItemStack, ImmutableMap<AlloyForgeRecipe.OverrideRange, ItemStack>> outputData = this.finalOutputData(this.overrideData);
        AlloyForgeRecipe recipe = new AlloyForgeRecipe(Optional.of(this), this.inputs, (ItemStack)outputData.getA(), this.minForgeTier, this.requiredFuel, (Map)outputData.getB());
        if (!isDataGenerated && this.outputData.prioritisedOutput()) {
            AlloyForgeRecipe.PENDING_RECIPES.put(recipe, new AlloyForgeRecipe.PendingRecipeData((Tuple<TagKey<Item>, Integer>)new Tuple(this.outputData.defaultTag(), (Object)this.outputData.count()), this.overrideData));
        }
        return recipe;
    }
}

