/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.utils.data;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.wispforest.alloyforgery.mixin.JsonDataLoaderAccessor;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.RegistriesAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class EndecDataLoader<T>
extends SimpleJsonResourceReloadListener<T> {
    protected final String type;
    protected final ResourceLocation id;
    protected final Endec<T> endec;
    protected final Set<ResourceLocation> dependencies;
    protected final SerializationContext context;
    protected final boolean requiresRegistries;
    @Nullable
    private HolderLookup.Provider registries = null;

    private EndecDataLoader(ResourceLocation id, String type, Endec<T> endec, SerializationContext context, boolean requiresRegistries, Set<ResourceLocation> value) {
        super(new DelayedRecursiveCodec(), FileToIdConverter.json((String)type));
        this.id = id;
        this.type = type;
        this.endec = endec;
        this.context = context;
        this.requiresRegistries = requiresRegistries;
        this.dependencies = Collections.unmodifiableSet(value);
        this.setupCodec();
    }

    public static <T> Builder<T> builder(String type, Endec<T> endec) {
        return new Builder<T>(type, endec);
    }

    public ResourceLocation getLoaderId() {
        return this.id;
    }

    public Set<ResourceLocation> getDependencyIds() {
        return this.dependencies;
    }

    public boolean requiresRegistries() {
        return this.requiresRegistries;
    }

    protected void setupCodec() {
        ((DelayedRecursiveCodec)((JsonDataLoaderAccessor)((Object)this)).codec()).setup(this.endec.toString(), codec -> CodecUtils.toCodec(this.endec, (SerializationContext)this.getContext()));
    }

    @ApiStatus.Internal
    public EndecDataLoader<T> setupOps(HolderLookup.Provider registries) {
        this.registries = registries;
        this.setupCodec();
        return this;
    }

    private SerializationContext getContext() {
        if (this.requiresRegistries) {
            Objects.requireNonNull(this.registries, "Can not build the needed context for the ManagedEndecDataLoader: " + String.valueOf(this.getLoaderId()));
            return this.context.withAttributes(new SerializationAttribute.Instance[]{RegistriesAttribute.fromCachedInfoGetter((RegistryOps.HolderLookupAdapter)new RegistryOps.HolderLookupAdapter(this.registries))});
        }
        return this.context;
    }

    protected Map<ResourceLocation, T> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        if (this.requiresRegistries && this.registries == null) {
            throw new IllegalStateException("Unable to prepare files as the given Registry access has not been setup on the server! [Id: " + String.valueOf(this.getLoaderId()) + "]");
        }
        Map entries = super.prepare(resourceManager, profiler);
        this.registries = null;
        return entries;
    }

    private static class DelayedRecursiveCodec<T>
    implements Codec<T> {
        private String name;
        private Supplier<Codec<T>> wrapped;

        private DelayedRecursiveCodec() {
        }

        public void setup(String name, Function<Codec<T>, Codec<T>> wrapped) {
            this.name = name;
            this.wrapped = Suppliers.memoize(() -> (Codec)wrapped.apply(this));
        }

        public <S> DataResult<Pair<T, S>> decode(DynamicOps<S> ops, S input) {
            return this.wrapped.get().decode(ops, input);
        }

        public <S> DataResult<S> encode(T input, DynamicOps<S> ops, S prefix) {
            return this.wrapped.get().encode(input, ops, prefix);
        }

        public String toString() {
            return "RecursiveCodec[" + this.name + "]";
        }
    }

    public static class Builder<T> {
        protected final String type;
        protected final Endec<T> endec;
        protected final Set<ResourceLocation> dependencies = new HashSet<ResourceLocation>();
        protected SerializationContext context = SerializationContext.empty();
        protected boolean requiresRegistries = false;

        Builder(String type, Endec<T> endec) {
            this.type = type;
            this.endec = endec;
        }

        public Builder<T> addDependencies(ResourceLocation ... dependencies) {
            return this.addDependencies(List.of(dependencies));
        }

        public Builder<T> addDependencies(Collection<ResourceLocation> dependencies) {
            this.dependencies.addAll(dependencies);
            return this;
        }

        public Builder<T> requiresRegistries(boolean value) {
            this.requiresRegistries = value;
            return this;
        }

        public Builder<T> setContext(SerializationContext context) {
            this.context = context;
            return this;
        }

        public EndecDataLoader<T> create(ResourceLocation id, PackType packType, final LoadedDataHandler<T> handler) {
            EndecDataLoader loader = new EndecDataLoader<T>(this, id, this.type, this.endec, this.context, this.requiresRegistries, this.dependencies){

                protected void apply(Map<ResourceLocation, T> prepared, ResourceManager manager, ProfilerFiller profiler) {
                    handler.handleData(prepared, manager, profiler);
                }
            };
            GeneralPlatformUtils.INSTANCE.registerLoader(id, packType, loader, this.requiresRegistries);
            return loader;
        }
    }

    public static interface LoadedDataHandler<T> {
        public void handleData(Map<ResourceLocation, T> var1, ResourceManager var2, ProfilerFiller var3);
    }
}

