package io.wispforest.alloyforgery;

import io.wispforest.alloyforgery.forges.ForgeRegistry;
import io.wispforest.alloyforgery.forges.ForgeTier;
import io.wispforest.alloyforgery.forges.ForgeTierDataLoader;
import io.wispforest.owo.itemgroup.Icon;
import io.wispforest.owo.itemgroup.OwoItemGroup;
import io.wispforest.owo.itemgroup.gui.ItemGroupButton;
import io.wispforest.owo.itemgroup.gui.ItemGroupTab;
import io.wispforest.alloyforgery.block.ForgeControllerBlock;
import java.util.*;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class AlloyForgeryItemGroup {

    private static List<ItemStack> CONTROLLER_CACHE = null;

    public static final OwoItemGroup GROUP = OwoItemGroup.builder(AlloyForgery.id("main"), () -> {
        if (CONTROLLER_CACHE == null) return null;
        return Icon.of(CONTROLLER_CACHE.isEmpty() ? Items.BARRIER.getDefaultInstance() : CONTROLLER_CACHE.get(0));
    }).initializer(group -> {
        group.tabs.add(new ItemGroupTab(Icon.of(ItemStack.EMPTY), Component.empty(), (context, entries) -> {
            if (CONTROLLER_CACHE == null) createControllerCache();
            CONTROLLER_CACHE.forEach(entries::accept);
        }, ItemGroupTab.DEFAULT_TEXTURE, true));

        group.addButton(ItemGroupButton.github(group, "https://github.com/LordDeatHunter/Alloy-Forgery"));
        group.addButton(ItemGroupButton.curseforge(group, "https://www.curseforge.com/minecraft/mc-mods/alloy-forgery"));
        group.addButton(ItemGroupButton.modrinth(group, "https://modrinth.com/mod/alloy-forgery"));
        group.addButton(ItemGroupButton.discord(group, "https://discord.gg/Pa5wDVm8Xv"));
    }).build();

    private static void createControllerCache() {
        final var blockList = new ArrayList<>(ForgeRegistry.getControllerBlocks());
        final var tierRegistry = ForgeTierDataLoader.getForgeRegistry(true);

        blockList.sort(Comparator.comparingInt(value -> {
            var tier = tierRegistry.getBoundForgeTier(((ForgeControllerBlock) value).forgeDefinitionId);

            if (tier == null) tier = ForgeTier.DEFAULT;

            return tier.value();
        }));

        CONTROLLER_CACHE = new ArrayList<>(blockList.size());
        blockList.forEach(block -> CONTROLLER_CACHE.add(block.asItem().getDefaultInstance()));
    }

}
