package io.wispforest.alloyforgery.mixin;

import com.google.common.collect.Multimap;
import net.minecraft.recipe.*;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipeType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.gen.Accessor;
import java.util.Map;

@Mixin(RecipeMap.class)
public interface PreparedRecipesAccessor {
    @Accessor("byType")
    Multimap<RecipeType<?>, RecipeHolder<?>> af$getRecipes();

    @Accessor("byType")
    @Mutable
    void af$setRecipes(Multimap<RecipeType<?>, RecipeHolder<?>> recipesByType);

    @Accessor("byKey")
    Map<ResourceLocation, RecipeHolder<?>> af$getRecipesById();

    @Accessor("byKey")
    @Mutable
    void af$setRecipesById(Map<ResourceLocation, RecipeHolder<?>> recipesById);
}
