/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery;

import io.wispforest.alloyforgery.block.ForgeControllerBlockEntity;
import io.wispforest.alloyforgery.forges.ForgeFuelDataLoader;
import io.wispforest.alloyforgery.utils.ExtObservable;
import io.wispforest.alloyforgery.utils.ForgeInputSlot;
import io.wispforest.endec.Endec;
import io.wispforest.owo.client.screens.ScreenUtils;
import io.wispforest.owo.client.screens.SlotGenerator;
import io.wispforest.owo.client.screens.SyncedProperty;
import io.wispforest.owo.util.EventSource;
import io.wispforest.owo.util.EventStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AlloyForgeScreenHandler
extends AbstractContainerMenu {
    public static MenuType<AlloyForgeScreenHandler> ALLOY_FORGE_SCREEN_HANDLER_TYPE;
    private final Container controllerInventory;
    private final boolean isServer;
    public final ForgeControllerBlockEntity forge;
    private final SyncedProperty<Integer> smeltProgress;
    private final SyncedProperty<Integer> fuelProgress;
    private final SyncedProperty<Integer> lavaProgress;
    private final SyncedProperty<Integer> requiredTierToCraft;
    private final SyncedProperty<Set<Integer>> disabledSlots;
    private final List<Slot> inputSlots;
    private final EventStream<Runnable> onClosedEvent = new EventStream(closeRuns -> () -> closeRuns.forEach(Runnable::run));

    public AlloyForgeScreenHandler(int syncId, Inventory playerInventory, ForgeControllerBlockEntity forge) {
        super(ALLOY_FORGE_SCREEN_HANDLER_TYPE, syncId);
        this.isServer = playerInventory.player instanceof ServerPlayer;
        this.forge = forge;
        this.controllerInventory = forge != null ? forge : new SimpleContainer(12);
        this.smeltProgress = this.createProperty(Integer.class, forge, (P provider) -> provider.smeltProgress, 0);
        this.fuelProgress = this.createProperty(Integer.class, forge, (P provider) -> provider.fuelProgress, 0);
        this.lavaProgress = this.createProperty(Integer.class, forge, (P provider) -> provider.lavaProgress, 0);
        this.requiredTierToCraft = this.createProperty(Integer.class, forge, (P provider) -> provider.requiredTierToCraft, -1);
        this.disabledSlots = this.createSetProperty(Integer.class, forge, provider -> provider.disabledSlots);
        this.addSlot(new Slot(this, this.controllerInventory, 11, 8, 74){

            public boolean mayPlace(ItemStack stack) {
                return ForgeFuelDataLoader.hasFuel(stack.getItem());
            }
        });
        this.addSlot(new Slot(this, this.controllerInventory, 10, 145, 50){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        });
        SlotGenerator.begin(x$0 -> this.addSlot((Slot)x$0), (int)44, (int)43).slotFactory((inventory, index, x, y) -> new ForgeInputSlot(inventory, index, x, y, this)).grid(this.controllerInventory, 0, 5, 2).defaultSlotFactory().moveTo(8, 107).playerInventory(playerInventory);
        this.inputSlots = this.slots.stream().filter(slot -> slot instanceof ForgeInputSlot).toList();
    }

    public <P, T> SyncedProperty<Set<T>> createSetProperty(Class<T> elementType, @Nullable P provider, Function<P, ExtObservable<Set<T>>> observableProviderFunc) {
        ParameterizedType type = AlloyForgeScreenHandler.createParameterizedType(Set.class, new Type[]{elementType});
        return this.createProperty(Set.class, this.endecBuilder().get((Type)type), provider, observableProviderFunc.andThen(listExtObservable -> listExtObservable), set -> new HashSet(set), new HashSet());
    }

    public <P, T> SyncedProperty<List<T>> createListProperty(Class<T> elementType, @Nullable P provider, Function<P, ExtObservable<List<T>>> observableProviderFunc) {
        ParameterizedType type = AlloyForgeScreenHandler.createParameterizedType(List.class, new Type[]{elementType});
        return this.createProperty(List.class, this.endecBuilder().get((Type)type), provider, observableProviderFunc.andThen(listExtObservable -> listExtObservable), list -> new ArrayList(list), new ArrayList());
    }

    private static ParameterizedType createParameterizedType(final Type rawType, final Type ... typeArgs) {
        if (typeArgs.length == 0) {
            throw new IllegalStateException("Unable to create ParameterizedType with zero type args!");
        }
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return typeArgs;
            }

            @Override
            public Type getRawType() {
                return rawType;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    public <P, T> SyncedProperty<T> createProperty(Class<T> clazz, @Nullable P provider, Function<P, ExtObservable<T>> observableProviderFunc, T initial) {
        return this.createProperty(clazz, this.endecBuilder().get(clazz), provider, observableProviderFunc, t -> t, initial);
    }

    public <P, T> SyncedProperty<T> createProperty(Class<T> clazz, @Nullable P provider, Function<P, ExtObservable<T>> observableProviderFunc, Function<T, T> cloneFunc, T initial) {
        return this.createProperty(clazz, this.endecBuilder().get(clazz), provider, observableProviderFunc, cloneFunc, initial);
    }

    public <P, T> SyncedProperty<T> createProperty(Class<T> clazz, Endec<T> endec, @Nullable P provider, Function<P, ExtObservable<T>> observableProviderFunc, Function<T, T> cloneFunc, T initial) {
        return provider != null && this.isServer ? this.createProperty(clazz, endec, observableProviderFunc.apply(provider), cloneFunc) : this.createProperty(clazz, endec, initial);
    }

    public <T> SyncedProperty<T> createProperty(Class<T> clazz, ExtObservable<T> initial, Function<T, T> cloneFunc) {
        return this.createProperty(clazz, this.endecBuilder().get(clazz), initial, cloneFunc);
    }

    public <T> SyncedProperty<T> createProperty(Class<T> clazz, Endec<T> endec, ExtObservable<T> initial, Function<T, T> cloneFunc) {
        SyncedProperty property = this.createProperty(clazz, endec, cloneFunc.apply(initial.get()));
        property.markDirty();
        this.onClosedEvent.source().subscribe(() -> ((EventSource.Subscription)initial.observeSub(t -> property.set(cloneFunc.apply(t)))).cancel());
        return property;
    }

    public void removed(Player player) {
        super.removed(player);
        ((Runnable)this.onClosedEvent.sink()).run();
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        return ScreenUtils.handleSlotTransfer((AbstractContainerMenu)this, (int)invSlot, (int)this.controllerInventory.getContainerSize());
    }

    public int getSmeltProgress() {
        return (Integer)this.smeltProgress.get();
    }

    public int getFuelProgress() {
        return (Integer)this.fuelProgress.get();
    }

    public int getLavaProgress() {
        return (Integer)this.lavaProgress.get();
    }

    public int getRequiredTierData() {
        return (Integer)this.requiredTierToCraft.get();
    }

    public boolean isSlotDisabled(Slot slot) {
        return ((Set)this.disabledSlots.get()).contains(slot.getContainerSlot());
    }

    public boolean stillValid(Player player) {
        return this.controllerInventory.stillValid(player);
    }

    public Container getControllerInventory() {
        return this.controllerInventory;
    }

    public List<Slot> getInputSlots() {
        return this.inputSlots;
    }
}

