/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.compat;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class LegacyIdMappings {
    private static final Map<ResourceLocation, ResourceLocation> MAPPINGS = new HashMap<ResourceLocation, ResourceLocation>();
    public static final String MOD_ID = "alloy_forgery";

    public static ResourceLocation remap(@Nullable ResourceLocation original) {
        if (original == null) {
            return null;
        }
        if (original.getNamespace().equals(MOD_ID)) {
            original = ResourceLocation.fromNamespaceAndPath((String)"alloy-forgery", (String)original.getPath());
        }
        return MAPPINGS.getOrDefault(original, original);
    }

    private static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"alloy-forgery", (String)path);
    }

    static {
        MAPPINGS.put(LegacyIdMappings.id("blackstone_forge_controller"), LegacyIdMappings.id("polished_blackstone_forge_controller"));
        MAPPINGS.put(LegacyIdMappings.id("brick_forge_controller"), LegacyIdMappings.id("bricks_forge_controller"));
        MAPPINGS.put(LegacyIdMappings.id("deepslate_forge_controller"), LegacyIdMappings.id("deepslate_bricks_forge_controller"));
        MAPPINGS.put(LegacyIdMappings.id("end_stone_forge_controller"), LegacyIdMappings.id("end_stone_bricks_forge_controller"));
        MAPPINGS.put(LegacyIdMappings.id("stone_brick_forge_controller"), LegacyIdMappings.id("stone_bricks_forge_controller"));
    }
}

