/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.data;

import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.data.DelayedTagGroupLoader;
import io.wispforest.alloyforgery.networking.AlloyForgeNetworking;
import io.wispforest.owo.network.ClientAccess;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.ApiStatus;

public class RecipeTagLoader
extends SimplePreparableReloadListener<Map<ResourceLocation, List<TagLoader.EntryWithSource>>> {
    public static final ResourceLocation ID = AlloyForgery.id("recipe_tag");
    public static final RecipeTagLoader INSTANCE = new RecipeTagLoader();
    private static final Map<ResourceLocation, Set<ResourceLocation>> RESOLVED_CLIENT_ENTRIES = new LinkedHashMap<ResourceLocation, Set<ResourceLocation>>();
    private static final Map<ResourceLocation, Set<ResourceLocation>> RESOLVED_SERVER_ENTRIES = new LinkedHashMap<ResourceLocation, Set<ResourceLocation>>();
    private boolean areEntriesResolved = true;
    private static final Map<ResourceLocation, List<TagLoader.EntryWithSource>> RAW_TAG_DATA = new LinkedHashMap<ResourceLocation, List<TagLoader.EntryWithSource>>();
    private final DelayedTagGroupLoader<RecipeHolder<Recipe<?>>> tagGroupLoader = new DelayedTagGroupLoader("tags/recipe");

    private RecipeTagLoader() {
    }

    protected Map<ResourceLocation, List<TagLoader.EntryWithSource>> prepare(ResourceManager manager, ProfilerFiller profiler) {
        return this.tagGroupLoader.load(manager);
    }

    protected void apply(Map<ResourceLocation, List<TagLoader.EntryWithSource>> prepared, ResourceManager manager, ProfilerFiller profiler) {
        RAW_TAG_DATA.clear();
        RAW_TAG_DATA.putAll(prepared);
        this.areEntriesResolved = false;
    }

    public static boolean isWithinTag(boolean isClient, ResourceLocation tag, RecipeHolder<?> entry) {
        return RecipeTagLoader.isWithinTag(isClient, tag, entry.id().registry());
    }

    public static boolean isWithinTag(boolean isClient, ResourceLocation tag, ResourceLocation recipeID) {
        Map<ResourceLocation, Set<ResourceLocation>> entries = isClient ? RESOLVED_CLIENT_ENTRIES : RESOLVED_SERVER_ENTRIES;
        return entries.containsKey(tag) && entries.get(tag).contains(recipeID);
    }

    @ApiStatus.Internal
    public void sendPlayerPacketAfterDataLoad(ServerPlayer player) {
        this.resolveEntries(player.level().getServer());
        this.sendTagPacket(player);
    }

    @ApiStatus.Internal
    public void onServerStarted(MinecraftServer server) {
        this.resolveEntries(server);
    }

    private void resolveEntries(MinecraftServer server) {
        if (this.areEntriesResolved) {
            return;
        }
        RecipeManager recipeManager = server.getRecipeManager();
        Map map = this.tagGroupLoader.setGetter(identifier -> Optional.ofNullable(recipeManager.byKey(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)identifier)).orElse(null))).build(RAW_TAG_DATA);
        RESOLVED_SERVER_ENTRIES.clear();
        map.forEach((id, recipes) -> RESOLVED_SERVER_ENTRIES.put((ResourceLocation)id, recipes.stream().map(RecipeHolder::id).map(ResourceKey::location).collect(Collectors.toSet())));
        this.areEntriesResolved = true;
    }

    public void sendTagPacket(ServerPlayer player) {
        AlloyForgeNetworking.CHANNEL.serverHandle((Player)player).send((Record)TagPacket.of(RESOLVED_SERVER_ENTRIES));
    }

    public record TagPacket(List<TagEntry> entries) {
        public static TagPacket of(Map<ResourceLocation, Set<ResourceLocation>> tagEntries) {
            return new TagPacket(tagEntries.entrySet().stream().map(entry -> new TagEntry((ResourceLocation)entry.getKey(), List.copyOf((Collection)entry.getValue()))).toList());
        }

        public static void handlePacket(TagPacket packet, ClientAccess access) {
            RESOLVED_CLIENT_ENTRIES.clear();
            RESOLVED_CLIENT_ENTRIES.putAll(packet.entries.stream().collect(Collectors.toMap(TagEntry::id, e -> new HashSet<ResourceLocation>(e.entries()))));
        }
    }

    public record TagEntry(ResourceLocation id, List<ResourceLocation> entries) {
    }
}

