/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.forges;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.forges.ForgeRegistry;
import io.wispforest.alloyforgery.forges.ForgeTier;
import io.wispforest.alloyforgery.utils.RecipeInjector;
import io.wispforest.alloyforgery.utils.data.EndecableModDataLoader;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.gson.GsonEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.registration.ComplexRegistryAction;
import io.wispforest.owo.registration.RegistryHelper;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

public record ForgeDefinition(Block material, ImmutableList<Block> additionalMaterials, boolean blockEntity) {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Endec<ForgeDefinition> FORGE_DEFINITION = MinecraftEndecs.IDENTIFIER.xmap(identifier -> ForgeRegistry.getForgeDefinition(identifier).orElseThrow(() -> new IllegalStateException("Unable to locate ForgerDefinition with Identifier: [ID: " + String.valueOf(identifier) + "]")), forgeDefinition -> forgeDefinition.id().orElseThrow(() -> new IllegalStateException("A Given forge Definition was not found within the ForgeRegistry!")));
    @ApiStatus.Internal
    public static final Map<ResourceLocation, ForgeTier> legacyForgeDefinitionIdToTier = new HashMap<ResourceLocation, ForgeTier>();
    private static final String RECIPE_PATTERN = "{\n    \"type\": \"minecraft:crafting_shaped\",\n    \"pattern\": [\n        \"###\",\n        \"#B#\",\n        \"###\"\n    ],\n    \"key\": {\n        \"#\": \"{material}\",\n        \"B\": \"minecraft:blast_furnace\"\n    },\n    \"result\": {\n        \"id\": \"{controller}\",\n        \"count\": 1\n    }\n}\n";

    public ForgeDefinition(Block material, ImmutableList<Block> additionalMaterials) {
        this(material, additionalMaterials, false);
    }

    public Optional<ResourceLocation> id() {
        return ForgeRegistry.getId(this);
    }

    @Deprecated
    @ApiStatus.Internal
    public static void loadAndEnqueue(ResourceLocation id, JsonObject json) {
        LOGGER.warn("A given Forge Definition '{}' has been loaded though a deprecated manor, please bug the author to switch over to the new system.", (Object)id);
        int forgeTier = GsonHelper.getAsInt((JsonObject)json, (String)"tier");
        float speedMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"speed_multiplier", (float)1.0f);
        int fuelCapacity = GsonHelper.getAsInt((JsonObject)json, (String)"fuel_capacity", (int)48000);
        ForgeTier tier = new ForgeTier(id, forgeTier, speedMultiplier, fuelCapacity, Optional.empty());
        legacyForgeDefinitionIdToTier.put(id, tier);
        ResourceLocation mainMaterialId = ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)json, (String)"material"));
        ArrayList<ResourceLocation> additionalMaterialIds = new ArrayList<ResourceLocation>();
        GsonHelper.getAsJsonArray((JsonObject)json, (String)"additional_materials", (JsonArray)new JsonArray()).forEach(jsonElement -> additionalMaterialIds.add(ResourceLocation.tryParse((String)jsonElement.getAsString())));
        ForgeDefinition.loadAndEnqueue(id, new RawForgeDefinition(mainMaterialId, additionalMaterialIds, false));
    }

    @ApiStatus.Internal
    private static void loadAndEnqueue(ResourceLocation id, RawForgeDefinition rawForgeDefinition) {
        ComplexRegistryAction action = ComplexRegistryAction.Builder.create(() -> {
            Block mainMaterial = (Block)BuiltInRegistries.BLOCK.getValue(rawForgeDefinition.materialId());
            ImmutableList.Builder additionalMaterialsBuilder = new ImmutableList.Builder();
            rawForgeDefinition.additionalMaterialIds().forEach(identifier -> additionalMaterialsBuilder.add((Object)((Block)BuiltInRegistries.BLOCK.getValue(identifier))));
            ForgeDefinition definition = new ForgeDefinition(mainMaterial, (ImmutableList<Block>)additionalMaterialsBuilder.build());
            ForgeRegistry.registerDefinition(id, definition);
        }).entries(rawForgeDefinition.blockIds()).build();
        RegistryHelper.get((Registry)BuiltInRegistries.BLOCK).runWhenPresent(action);
    }

    public boolean isBlockValid(Block block) {
        return block == this.material || this.additionalMaterials.contains((Object)block);
    }

    public JsonElement generateRecipe(ResourceLocation id) {
        String recipe = RECIPE_PATTERN.replace("{material}", BuiltInRegistries.ITEM.getKey((Object)this.material.asItem()).toString());
        recipe = recipe.replace("{controller}", BuiltInRegistries.ITEM.getKey((Object)ForgeRegistry.getControllerBlock(id).get().asItem()).toString());
        return (JsonElement)ForgeRegistry.GSON.fromJson(recipe, JsonObject.class);
    }

    public static void runDataLoaders() {
        EndecableModDataLoader.of(AlloyForgery.id("old_forge_definition_loader"), "alloy_forges", GsonEndec.INSTANCE.xmap(JsonElement::getAsJsonObject, jsonObject -> jsonObject), ForgeDefinition::loadAndEnqueue).load();
        EndecableModDataLoader.of(AlloyForgery.id("forge_definition_loader"), "alloy_forge/controller", RawForgeDefinition.ENDEC, ForgeDefinition::loadAndEnqueue).load();
    }

    public static void injectRecipeAdditions() {
        RecipeInjector.ADD_RECIPES.register(instance -> {
            for (Map.Entry<ResourceLocation, ForgeDefinition> forgeEntry : ForgeRegistry.getForgeEntries()) {
                ResourceLocation id = forgeEntry.getKey();
                try {
                    ShapedRecipe recipe = (ShapedRecipe)((Pair)RecipeSerializer.SHAPED_RECIPE.codec().codec().decode((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)instance.lookup()), (Object)forgeEntry.getValue().generateRecipe(id)).getOrThrow(string -> new IllegalStateException("Unable to generate recipe for given ForgeDefinition [" + String.valueOf(id) + "]: " + string))).getFirst();
                    instance.addRecipe(id.withSuffix("_recipe"), recipe);
                }
                catch (Throwable e) {
                    LOGGER.error("{} recipe had a issue!", (Object)id, (Object)e);
                }
            }
        });
    }

    @Override
    public String toString() {
        return "ForgeDefinition{material=" + String.valueOf(this.material) + ", additionalMaterials=" + String.valueOf(this.additionalMaterials) + "}";
    }

    private record RawForgeDefinition(ResourceLocation materialId, List<ResourceLocation> additionalMaterialIds, boolean isBlockEntity) {
        public static final StructEndec<RawForgeDefinition> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.fieldOf("material", RawForgeDefinition::materialId), (StructField)MinecraftEndecs.IDENTIFIER.listOf().optionalFieldOf("additional_materials", RawForgeDefinition::additionalMaterialIds, List.of()), (StructField)Endec.BOOLEAN.optionalFieldOf("is_block_entity", RawForgeDefinition::isBlockEntity, (Object)false), RawForgeDefinition::new);

        public List<ResourceLocation> blockIds() {
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(this.additionalMaterialIds);
            list.addFirst(this.materialId);
            return list;
        }
    }
}

