/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.neoforge.api;

import io.wispforest.alloyforgery.neoforge.api.LongResourceStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public abstract class SingleVariantDropletStorage<T extends Resource>
extends SnapshotJournal<LongResourceStack<T>>
implements ResourceHandler<T> {
    public static final long DROPLETS_PER_MB = 81L;
    public static final long BUCKET_VOLUME = 81000L;
    public T variant = this.getBlankVariant();
    public long amount = 0L;

    protected long getCapacity() {
        return this.getCapacity(this.variant);
    }

    protected abstract T getBlankVariant();

    protected abstract long getCapacity(T var1);

    protected boolean canInsert(T variant) {
        return true;
    }

    protected boolean canExtract(T variant) {
        return true;
    }

    protected void onFinalCommit() {
    }

    protected void onRootCommit(LongResourceStack<T> originalState) {
        this.onFinalCommit();
    }

    public int size() {
        return 1;
    }

    public boolean isValid(int i, T resource) {
        return this.canExtract(resource) && this.canInsert(resource);
    }

    private static void checkNonEmptyNonNegative(Resource resource, long value) {
        if (resource.isEmpty()) {
            throw new IllegalArgumentException("Expected resource to be non-empty: " + String.valueOf(resource));
        }
        if (value < 0L) {
            throw new IllegalArgumentException("Expected value to be non-negative: " + value);
        }
    }

    public long insertDroplets(T insertedVariant, long maxAmount, TransactionContext transaction) {
        long insertedAmount;
        SingleVariantDropletStorage.checkNonEmptyNonNegative(insertedVariant, maxAmount);
        if ((insertedVariant.equals(this.variant) || this.variant.isEmpty()) && this.canInsert(insertedVariant) && (insertedAmount = Math.min(maxAmount, this.getCapacity(insertedVariant) - this.amount)) > 0L) {
            long remainder = insertedAmount % 81L;
            if (remainder > 0L) {
                long overflowAmount = 81L - remainder;
                insertedAmount += overflowAmount;
            }
            this.updateSnapshots(transaction);
            if (this.variant.isEmpty()) {
                this.variant = insertedVariant;
                this.amount = insertedAmount;
            } else {
                this.amount += insertedAmount;
            }
            return insertedAmount;
        }
        return 0L;
    }

    public int insert(int i, T insertedVariant, int maxAmount, TransactionContext transaction) {
        return (int)Math.ceil((float)this.insertDroplets(insertedVariant, (long)maxAmount * 81L, transaction) / 81.0f);
    }

    public long extractDroplets(T extractedVariant, long maxAmount, TransactionContext transaction) {
        long extractedAmount;
        SingleVariantDropletStorage.checkNonEmptyNonNegative(extractedVariant, maxAmount);
        if (extractedVariant.equals(this.variant) && this.canExtract(extractedVariant) && (extractedAmount = Math.min(maxAmount, this.amount)) > 0L) {
            this.updateSnapshots(transaction);
            this.amount -= extractedAmount;
            if (this.amount == 0L) {
                this.variant = this.getBlankVariant();
            }
            return extractedAmount;
        }
        return 0L;
    }

    public int extract(int i, T extractedVariant, int maxAmount, TransactionContext transaction) {
        return (int)Math.floor((float)this.extractDroplets(extractedVariant, (long)maxAmount * 81L, transaction) / 81.0f);
    }

    public boolean isResourceBlank() {
        return this.variant.isEmpty();
    }

    public T getResource(int i) {
        return this.variant;
    }

    public long getAmountAsLong(int i) {
        return (long)Math.ceil((double)this.amount / 81.0);
    }

    public long getCapacityAsLong(int i, T resource) {
        return this.getCapacity(resource) / 81L;
    }

    protected LongResourceStack<T> createSnapshot() {
        return new LongResourceStack<T>(this.variant, this.amount);
    }

    protected void revertToSnapshot(LongResourceStack<T> snapshot) {
        this.variant = snapshot.resource();
        this.amount = snapshot.amount();
    }

    public String toString() {
        return "SingleVariantStorage[%d %s]".formatted(this.amount, this.variant);
    }
}

