/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.neoforge.mixin.owo;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.wispforest.owo.Owo;
import io.wispforest.owo.moddata.ModDataConsumer;
import io.wispforest.owo.moddata.ModDataLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.commons.io.FilenameUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ModDataLoader.class})
public class ModDataLoaderMixin {
    @Shadow
    @Final
    private static Gson GSON;

    @WrapMethod(method={"lambda$load$0(Lio/wispforest/owo/moddata/ModDataConsumer;Ljava/util/Map;Lnet/neoforged/neoforgespi/language/IModInfo;)V"})
    private static void adjustOutput(ModDataConsumer consumer, Map<ResourceLocation, JsonObject> foundFiles, IModInfo container, Operation<Void> original) {
        ArrayList<String> modids = new ArrayList<String>(container.getConfig().getConfigElement(new String[]{"provides"}).orElse(List.of()));
        modids.add(container.getModId());
        for (String currentModid : modids) {
            String relativePath = String.format("data/%s/%s", currentModid, consumer.getDataSubdirectory());
            ModDataLoaderMixin.tryLoadJarContentsFrom(GSON, foundFiles, currentModid, container.getOwningFile().getFile().getContents(), relativePath);
        }
    }

    @Unique
    private static void tryLoadJarContentsFrom(Gson GSON, Map<ResourceLocation, JsonObject> foundFiles, String namespace, JarContents jarContents, String relativePath) {
        try {
            jarContents.visitContent(relativePath, (path, resource) -> {
                if (!path.endsWith(".json")) {
                    return;
                }
                try (BufferedReader reader = resource.bufferedReader();){
                    String idPath = path.replace(relativePath + "/", "");
                    foundFiles.put(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)FilenameUtils.removeExtension((String)idPath)), (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class));
                }
                catch (IOException e) {
                    Owo.LOGGER.warn("### Unable to open data file {} ++ Stacktrace below ###", (Object)path, (Object)e);
                }
            });
        }
        catch (Exception e) {
            Owo.LOGGER.error("### Unable to traverse data tree {}:{} ++ Stacktrace below ###", new Object[]{namespace, relativePath, e});
        }
    }
}

