/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.utils.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import io.wispforest.alloyforgery.utils.data.EndecedHandler;
import io.wispforest.endec.Endec;
import io.wispforest.owo.moddata.ModDataConsumer;
import io.wispforest.owo.moddata.ModDataLoader;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class EndecableModDataLoader
implements ModDataConsumer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ResourceLocation id;
    private final String subdirectory;
    private final EndecedHandler<?> handler;

    private EndecableModDataLoader(ResourceLocation id, String subdirectory, EndecedHandler<?> handler) {
        this.id = id;
        this.subdirectory = subdirectory;
        this.handler = handler;
    }

    public static <T> EndecableModDataLoader of(ResourceLocation id, String dataType, Endec<T> endec, BiConsumer<ResourceLocation, T> consumer) {
        return new EndecableModDataLoader(id, dataType, new EndecedHandler<T>(endec, consumer));
    }

    public static <T> EndecableModDataLoader of(ResourceLocation id, String dataType, String fieldName, Endec<T> endec, BiConsumer<ResourceLocation, T> consumer) {
        return new EndecableModDataLoader(id, dataType, EndecedHandler.of(fieldName, endec, consumer, (ResourceLocation entryId) -> LOGGER.warn("A given entry within the [{}] Data Loader was found to be missing any data! [EntryId: {}]", (Object)id, entryId)));
    }

    public void load() {
        ModDataLoader.load((ModDataConsumer)this);
    }

    public String getDataSubdirectory() {
        return this.subdirectory;
    }

    public void acceptParsedFile(ResourceLocation id, JsonObject object) {
        this.handler.handle(id, (JsonElement)object);
    }
}

