/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.forges;

import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.ForgeControllerItem;
import io.wispforest.alloyforgery.block.ForgeControllerBlock;
import io.wispforest.alloyforgery.block.ForgeControllerBlockEntity;
import io.wispforest.alloyforgery.forges.ForgeDefinition;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import io.wispforest.endec.Endec;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.util.TagInjector;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ForgeRegistry {
    public static Endec<ForgeDefinition> FORGE_DEFINITION = MinecraftEndecs.IDENTIFIER.xmap(identifier -> ForgeRegistry.getForgeDefinition(identifier).orElseThrow(() -> new IllegalStateException("Unable to locate ForgerDefinition with Identifier: [ID: " + String.valueOf(identifier) + "]")), forgeDefinition -> {
        for (Map.Entry<class_2960, ForgeDefinition> entry : ForgeRegistry.getForgeEntries()) {
            if (entry.getValue() != forgeDefinition) continue;
            return entry.getKey();
        }
        throw new IllegalStateException();
    });
    public static final Gson GSON = new Gson();
    private static final class_2960 MINEABLE_PICKAXE = class_2960.method_60654((String)"mineable/pickaxe");
    private static final Map<class_2960, ForgeDefinition> ID_TO_FORGE_DEFINITION = new LinkedHashMap<class_2960, ForgeDefinition>();
    private static final Map<ForgeDefinition, class_2960> FORGE_DEFINITION_TO_ID = new LinkedHashMap<ForgeDefinition, class_2960>();
    private static final Map<class_2960, class_2248> CONTROLLER_BLOCK_REGISTRY = new LinkedHashMap<class_2960, class_2248>();
    private static final Map<class_2960, EntryHolder> REGISTERED_ENTRIES = new LinkedHashMap<class_2960, EntryHolder>();

    public static void handleLoadedEntries(boolean blockRegistry) {
        for (EntryHolder value : REGISTERED_ENTRIES.values()) {
            if (blockRegistry) {
                value.registerBlock();
                continue;
            }
            value.registerItem();
        }
    }

    static void registerDefinition(class_2960 forgeDefinitionId, ForgeDefinition definition) {
        class_2960 controllerId = AlloyForgery.id(class_7923.field_41175.method_10221((Object)definition.material()).method_12832() + "_forge_controller");
        REGISTERED_ENTRIES.put(controllerId, new EntryHolder(forgeDefinitionId, controllerId, ForgeControllerBlock::of));
        ForgeRegistry.store(forgeDefinitionId, definition);
    }

    public static Optional<ForgeDefinition> getForgeDefinition(class_2960 id) {
        return ID_TO_FORGE_DEFINITION.containsKey(id) ? Optional.of(ID_TO_FORGE_DEFINITION.get(id)) : Optional.empty();
    }

    public static Optional<class_2248> getControllerBlock(class_2960 id) {
        return ID_TO_FORGE_DEFINITION.containsKey(id) ? Optional.of(CONTROLLER_BLOCK_REGISTRY.get(id)) : Optional.empty();
    }

    public static Optional<class_2960> getId(ForgeDefinition definition) {
        return FORGE_DEFINITION_TO_ID.containsKey(definition) ? Optional.of(FORGE_DEFINITION_TO_ID.get(definition)) : Optional.empty();
    }

    public static Set<Map.Entry<class_2960, ForgeDefinition>> getForgeEntries() {
        return ID_TO_FORGE_DEFINITION.entrySet();
    }

    public static Set<class_2960> getForgeIds() {
        return ID_TO_FORGE_DEFINITION.keySet();
    }

    public static List<class_2248> getControllerBlocks() {
        return CONTROLLER_BLOCK_REGISTRY.values().stream().toList();
    }

    private static void store(class_2960 id, ForgeDefinition definition) {
        FORGE_DEFINITION_TO_ID.put(definition, id);
        ID_TO_FORGE_DEFINITION.put(id, definition);
    }

    private static final class EntryHolder {
        private final class_2960 controllerId;
        private final class_2960 forgeDefinitionId;
        private final Supplier<ForgeControllerBlock> controllerBlock;

        private EntryHolder(class_2960 forgeDefinitionId, class_2960 controllerId, BiFunction<class_2960, class_2960, ForgeControllerBlock> controllerBlock) {
            this.forgeDefinitionId = forgeDefinitionId;
            this.controllerId = controllerId;
            this.controllerBlock = Suppliers.memoize(() -> (ForgeControllerBlock)((Object)((Object)controllerBlock.apply(forgeDefinitionId, controllerId))));
        }

        private class_1792 createItem() {
            return new ForgeControllerItem(this.controllerBlock(), new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)this.controllerId)).method_63685());
        }

        public void registerItem() {
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)this.controllerId, (Object)this.createItem());
        }

        public void registerBlock() {
            ForgeControllerBlock controllerBlock = this.controllerBlock();
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)this.controllerId, (Object)((Object)controllerBlock));
            TagInjector.inject((class_2378)class_7923.field_41175, (class_2960)MINEABLE_PICKAXE, (Object[])new class_2248[]{controllerBlock});
            CONTROLLER_BLOCK_REGISTRY.put(this.forgeDefinitionId, (class_2248)controllerBlock);
            GeneralPlatformUtils.INSTANCE.addToBlockEntity(ForgeControllerBlockEntity.FORGE_CONTROLLER_BLOCK_ENTITY, new class_2248[]{controllerBlock});
        }

        public ForgeControllerBlock controllerBlock() {
            return this.controllerBlock.get();
        }
    }
}

