/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonSyntaxException;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.block.ForgeControllerBlockEntity;
import io.wispforest.alloyforgery.forges.ForgeTier;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipeInput;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipeSerializer;
import io.wispforest.alloyforgery.recipe.RawAlloyForgeRecipe;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.util.RecipeRemainderStorage;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_10355;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3956;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9326;
import net.minecraft.class_9887;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class AlloyForgeRecipe
implements class_1860<AlloyForgeRecipeInput> {
    private static final Map<class_1792, class_1799> GLOBAL_REMAINDERS = new HashMap<class_1792, class_1799>();
    private static final List<Integer> INPUT_SLOT_INDICES = IntStream.rangeClosed(0, 9).boxed().toList();
    public static final Map<AlloyForgeRecipe, PendingRecipeData> PENDING_RECIPES = new HashMap<AlloyForgeRecipe, PendingRecipeData>();
    public final Optional<RawAlloyForgeRecipe> rawRecipeData;
    private Optional<class_2960> secondaryID = Optional.empty();
    private final Map<class_1856, Integer> inputs;
    private class_1799 output;
    private final int minForgeTier;
    private final int fuelPerTick;
    private ImmutableMap<OverrideRange, class_1799> tierOverrides;
    @Nullable
    private class_9887 ingredientPlacement;

    public AlloyForgeRecipe(Optional<RawAlloyForgeRecipe> rawRecipeData, Map<class_1856, Integer> inputs, class_1799 output, int minForgeTier, int fuelPerTick, Map<OverrideRange, class_1799> overrides) {
        this.rawRecipeData = rawRecipeData;
        this.inputs = inputs;
        this.output = output;
        this.minForgeTier = minForgeTier;
        this.fuelPerTick = fuelPerTick;
        this.tierOverrides = ImmutableMap.copyOf(overrides);
    }

    public AlloyForgeRecipe(Map<class_1856, Integer> inputs, class_1799 output, int minForgeTier, int fuelPerTick, Map<OverrideRange, class_1799> overrides, Optional<class_2960> secondaryID) {
        this(Optional.empty(), inputs, output, minForgeTier, fuelPerTick, overrides);
        this.secondaryID = secondaryID;
    }

    public Optional<class_2960> secondaryID() {
        return this.secondaryID;
    }

    public void finishRecipe(class_7871.class_7872 registryLookup, PendingRecipeData pendingData, Function<AlloyForgeRecipe, class_2960> lookup) {
        if (pendingData.defaultTag() != null) {
            Optional itemEntryList = registryLookup.method_46751(class_7924.field_41197).method_46733((class_6862)pendingData.defaultTag().method_15442());
            itemEntryList.ifPresentOrElse(registryEntries -> {
                this.output = ((class_1792)registryEntries.method_40240(0).comp_349()).method_7854();
                this.output.method_7939(((Integer)pendingData.defaultTag().method_15441()).intValue());
            }, () -> {
                throw new InvalidTagException("Default tag " + String.valueOf(((class_6862)pendingData.defaultTag().method_15442()).comp_327()) + " of recipe " + String.valueOf(lookup.apply(this)) + " must not be empty");
            });
        }
        ImmutableMap.Builder overrides = ImmutableMap.builder();
        pendingData.unfinishedTierOverrides().forEach((range, override) -> {
            if (override.isCountOnly()) {
                class_1799 stack = this.output.method_7972();
                stack.method_7939(override.count());
                if (!override.components().method_57848()) {
                    stack.method_59692(override.components());
                }
                overrides.put(range, (Object)stack);
            } else {
                overrides.put(range, (Object)override.stack());
            }
        });
        this.tierOverrides = overrides.build();
    }

    public static void addRemainders(Map<class_1792, class_1799> remainders) {
        GLOBAL_REMAINDERS.putAll(remainders);
    }

    public boolean method_8118() {
        return true;
    }

    public boolean matches(AlloyForgeRecipeInput input, class_1937 world) {
        return this.tryBind(input) != null;
    }

    public Int2IntMap tryBind(AlloyForgeRecipeInput input) {
        ConcurrentLinkedQueue<Integer> indices = new ConcurrentLinkedQueue<Integer>(INPUT_SLOT_INDICES);
        Int2IntLinkedOpenHashMap boundSlots = new Int2IntLinkedOpenHashMap();
        for (Map.Entry<class_1856, Integer> ingredient : this.inputs.entrySet()) {
            int remaining = ingredient.getValue();
            for (int index : indices) {
                class_1799 stack = input.method_59984(index);
                if (!ingredient.getKey().method_8093(stack)) continue;
                boundSlots.put(index, Math.min(stack.method_7947(), remaining));
                indices.remove(index);
                if ((remaining -= stack.method_7947()) > 0) continue;
                break;
            }
            if (remaining <= 0) continue;
            return null;
        }
        Iterator<Object> iterator = indices.iterator();
        block2: while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            class_1799 stack = input.method_59984(index);
            if (stack.method_7960()) continue;
            for (class_1856 ingredient : this.inputs.keySet()) {
                if (!ingredient.method_8093(stack)) continue;
                continue block2;
            }
            return null;
        }
        return boundSlots;
    }

    public class_9887 method_61671() {
        if (this.ingredientPlacement == null) {
            this.ingredientPlacement = class_9887.method_61683(this.getIngredientsMap().keySet().stream().map(Optional::of).toList());
        }
        return this.ingredientPlacement;
    }

    public Map<class_1856, Integer> getIngredientsMap() {
        return this.inputs;
    }

    public class_1799 craft(AlloyForgeRecipeInput input, class_7225.class_7874 lookup) {
        class_1799 class_17992;
        class_1263 class_12632 = input.inventory();
        if (class_12632 instanceof ForgeControllerBlockEntity) {
            ForgeControllerBlockEntity controller = (ForgeControllerBlockEntity)class_12632;
            class_17992 = this.getResult(controller.forgeTier().value());
        } else {
            class_17992 = this.getBaseResult();
        }
        return class_17992;
    }

    public void consumeIngredients(AlloyForgeRecipeInput input) {
        class_1263 inventory = input.inventory();
        this.tryBind(input).forEach((arg_0, arg_1) -> ((class_1263)inventory).method_5434(arg_0, arg_1));
    }

    @Nullable
    public static class_2371<class_1799> gatherRemainders(class_8786<AlloyForgeRecipe> recipeEntry, AlloyForgeRecipeInput input) {
        Map owoRemainders;
        class_2960 id = recipeEntry.comp_1932().method_29177();
        AlloyForgeRecipe recipe = (AlloyForgeRecipe)recipeEntry.comp_1933();
        class_2371 remainders = class_2371.method_10213((int)input.method_59983(), (Object)class_1799.field_8037);
        Map map = owoRemainders = RecipeRemainderStorage.has((class_2960)id) ? RecipeRemainderStorage.get((class_2960)id) : Map.of();
        if (owoRemainders.isEmpty() && GLOBAL_REMAINDERS.isEmpty()) {
            return null;
        }
        boolean setAnyRemainders = false;
        IntIterator intIterator = recipe.tryBind(input).keySet().iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            class_1792 item = input.method_59984(i).method_7909();
            if (!owoRemainders.isEmpty()) {
                if (!owoRemainders.containsKey(item)) continue;
                remainders.set(i, (Object)((class_1799)owoRemainders.get(item)).method_7972());
                setAnyRemainders = true;
                continue;
            }
            if (!GLOBAL_REMAINDERS.containsKey(item)) continue;
            remainders.set(i, (Object)GLOBAL_REMAINDERS.get(item).method_7972());
            setAnyRemainders = true;
        }
        return setAnyRemainders ? remainders : null;
    }

    @ApiStatus.Internal
    public class_1799 getBaseResult() {
        return this.output.method_7972();
    }

    public class_1799 getResult(int forgeTier) {
        class_1799 stack = ((class_1799)this.tierOverrides.getOrDefault(this.tierOverrides.keySet().stream().filter(overrideRange -> overrideRange.test(forgeTier)).findAny().orElse(null), (Object)this.output)).method_7972();
        if (stack.method_7909() == class_1802.field_8162) {
            int stackCount = stack.method_7947();
            stack = this.output.method_7972();
            stack.method_7939(stackCount);
        }
        return stack;
    }

    public class_1865<? extends class_1860<AlloyForgeRecipeInput>> method_8119() {
        return AlloyForgeRecipeSerializer.INSTANCE;
    }

    public class_3956<? extends class_1860<AlloyForgeRecipeInput>> method_17716() {
        return Type.INSTANCE;
    }

    public class_10355 method_64668() {
        return null;
    }

    public int getMinForgeTier() {
        return this.minForgeTier;
    }

    public int getFuelPerTick() {
        return this.fuelPerTick;
    }

    public ImmutableMap<OverrideRange, class_1799> getTierOverrides() {
        return this.tierOverrides;
    }

    public record PendingRecipeData(@Nullable class_3545<class_6862<class_1792>, Integer> defaultTag, Map<OverrideRange, PendingOverride> unfinishedTierOverrides) {
    }

    public static class Type
    implements class_3956<AlloyForgeRecipe> {
        public static final class_2960 ID = AlloyForgery.id("forging");
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }

    public record OverrideRange(int lowerBound, int upperBound) {
        public static Endec<OverrideRange> OVERRIDE_RANGE = StructEndecBuilder.of((StructField)Endec.INT.fieldOf("lowerBound", OverrideRange::lowerBound), (StructField)Endec.INT.fieldOf("upperBound", OverrideRange::upperBound), OverrideRange::new);

        public OverrideRange(int lowerBound) {
            this(lowerBound, -1);
        }

        public boolean test(int value) {
            return value >= this.lowerBound && (this.upperBound == -1 || value <= this.upperBound);
        }

        public static OverrideRange fromString(String s) {
            OverrideRange overrideRange;
            if (s.matches("\\d+\\+")) {
                overrideRange = new OverrideRange(Integer.parseInt(s.substring(0, s.length() - 1)));
            } else if (s.matches("\\d+ to \\d+")) {
                overrideRange = new OverrideRange(Integer.parseInt(s.substring(0, s.indexOf(" "))), Integer.parseInt(s.substring(s.lastIndexOf(" ") + 1, s.length())));
            } else if (s.matches("\\d+")) {
                overrideRange = new OverrideRange(Integer.parseInt(s), Integer.parseInt(s));
            } else {
                throw new JsonSyntaxException("Invalid override range token: " + s);
            }
            return overrideRange;
        }

        public class_2561 toText(boolean isClientSide) {
            class_2561 lowerTierName = ForgeTier.toName(isClientSide, this.lowerBound);
            if (this.upperBound != this.lowerBound) {
                if (this.upperBound == -1) {
                    return class_2561.method_43469((String)"tooltip.alloy_forgery.override_range.greater_or_equal_to", (Object[])new Object[]{lowerTierName});
                }
                Character[] to = (Character[])" to ".chars().mapToObj(value -> Character.valueOf((char)value)).toArray(Character[]::new);
                class_2561 upperTierName = ForgeTier.toName(isClientSide, this.lowerBound);
                return class_2561.method_43469((String)"tooltip.alloy_forgery.override_range.range", (Object[])new Object[]{lowerTierName, upperTierName});
            }
            return class_2561.method_43469((String)"tooltip.alloy_forgery.override_range.equal_to", (Object[])new Object[]{lowerTierName});
        }

        @Override
        public String toString() {
            String outString = String.valueOf(this.lowerBound);
            Stream<Character> chars = outString.chars().mapToObj(value -> Character.valueOf((char)value));
            if (this.upperBound != this.lowerBound) {
                if (this.upperBound == -1) {
                    chars = Stream.concat(chars, Stream.of(Character.valueOf('+')));
                } else {
                    Character[] to = (Character[])" to ".chars().mapToObj(value -> Character.valueOf((char)value)).toArray(Character[]::new);
                    chars = Stream.concat(chars, Arrays.stream(to));
                    Character[] bound = (Character[])String.valueOf(this.upperBound).chars().mapToObj(value -> Character.valueOf((char)value)).toArray(Character[]::new);
                    chars = Stream.concat(chars, Arrays.stream(bound));
                }
            }
            StringBuffer output = new StringBuffer();
            chars.forEach(character -> output.append(character));
            return output.toString();
        }
    }

    public record PendingOverride(@Nullable class_1792 item, int count, class_9326 components) {
        public boolean isCountOnly() {
            return this.item == null;
        }

        public static PendingOverride onlyCount(int count) {
            return new PendingOverride(null, count, class_9326.field_49588);
        }

        public static PendingOverride ofItem(class_1792 item, int count) {
            return new PendingOverride(item, count, class_9326.field_49588);
        }

        public class_1799 stack() {
            class_1799 stack = new class_1799((class_1935)this.item, this.count);
            stack.method_59692(this.components);
            return new class_1799((class_1935)this.item, this.count);
        }
    }

    public static class InvalidTagException
    extends RuntimeException {
        public InvalidTagException(String message) {
            super(message);
        }
    }
}

