/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.fabric;

import com.mojang.serialization.Codec;
import io.wispforest.alloyforgery.utils.FluidStorage;
import io.wispforest.endec.Endec;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.format.nbt.NbtDeserializer;
import io.wispforest.owo.serialization.format.nbt.NbtSerializer;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.InsertionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3612;
import net.minecraft.class_7225;

public final class FluidHolderImpl
extends SingleVariantStorage<FluidVariant>
implements InsertionOnlyStorage<FluidVariant>,
FluidStorage {
    public static final Endec<FluidVariant> FLUID_VARIANT = CodecUtils.toEndec((Codec)FluidVariant.CODEC).catchErrors((ctx, deserializer, e) -> FluidVariant.blank());
    private final Runnable onCommitAction;

    public FluidHolderImpl(Runnable onCommitAction) {
        this.onCommitAction = onCommitAction;
    }

    protected FluidVariant getBlankVariant() {
        return FluidVariant.blank();
    }

    protected long getCapacity(FluidVariant variant) {
        return 81081L;
    }

    protected void onFinalCommit() {
        this.onCommitAction.run();
    }

    protected boolean canInsert(FluidVariant variant) {
        return variant.isOf((Object)class_3612.field_15908);
    }

    protected boolean canExtract(FluidVariant variant) {
        return false;
    }

    public Iterator<StorageView<FluidVariant>> iterator() {
        return super.iterator();
    }

    @Override
    public void readNbt(class_2487 nbt, class_7225.class_7874 lookupProvider) {
        this.amount = nbt.method_10537("Amount");
        this.variant = (TransferVariant)FLUID_VARIANT.decodeFully(NbtDeserializer::of, (Object)nbt.method_10562("Variant"));
    }

    @Override
    public void writeNbt(class_2487 nbt, class_7225.class_7874 lookupProvider) {
        nbt.method_10544("Amount", this.amount);
        nbt.method_10566("Variant", (class_2520)FLUID_VARIANT.encodeFully(NbtSerializer::of, (Object)((FluidVariant)this.variant)));
    }

    @Override
    public float fullnessAmount() {
        return (float)this.getAmount() / 81000.0f;
    }

    @Override
    public long getFluidAmountInDroplets() {
        return this.amount;
    }

    @Override
    public long setFluidAmountInDroplets(long amount) {
        long cappedAmount = Math.min(amount, this.getCapacity());
        long spilledAmount = amount - cappedAmount;
        this.amount = Math.min(amount, this.getCapacity());
        return spilledAmount <= 0L ? 0L : spilledAmount;
    }
}

