package io.wispforest.alloyforgery.mixin;

import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipe;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

@Mixin(ReloadableServerResources.class)
public abstract class DataPackContentsMixin {

    @Shadow
    @Final
    private RecipeManager recipeManager;
    @Shadow
    @Final
    private ReloadableServerRegistries.Holder reloadableRegistries;

    @Inject(method = "applyPendingTagLoads", at = @At("TAIL"))
    private void alloy_forgery$onRefresh(CallbackInfo ci) {
        var recipeEntries = GeneralPlatformUtils.INSTANCE.getAllOfType(recipeManager, AlloyForgeRecipe.Type.INSTANCE);

        var map = new HashMap<AlloyForgeRecipe, ResourceLocation>();

        for (var entry : recipeEntries) {
            map.put(entry.value(), entry.id().location());
        }

        AlloyForgeRecipe.PENDING_RECIPES.forEach((recipe, pendingRecipeData) -> recipe.finishRecipe(this.reloadableRegistries.lookup(), pendingRecipeData, key -> map.getOrDefault(key, ResourceLocation.fromNamespaceAndPath(AlloyForgery.MOD_ID, "unknown_recipe"))));

        AlloyForgeRecipe.PENDING_RECIPES.clear();
    }
}
