package io.wispforest.alloyforgery.mixin;

import com.mojang.datafixers.util.Either;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.tags.TagKey;

@Mixin(value = HolderSet.Named.class, priority = 2000)
public abstract class RegistryEntryListNamedMixin<T> extends HolderSet.ListBacked<T> {
    @Shadow
    protected abstract List<Holder<T>> contents();

    @Shadow
    private @Nullable List<Holder<T>> entries;

    @Shadow
    public abstract Either<TagKey<T>, List<Holder<T>>> unwrap();

    @Shadow
    public abstract Optional<TagKey<T>> unwrapKey();

    @Shadow
    public abstract TagKey<T> getTag();

    @Override
    public boolean equals(Object obj) {
        if (obj == this) return true;

        return obj instanceof HolderSet.Named<?> named && this.getTag().equals(named.key());
    }

    @Override
    public int hashCode() {
        return this.getTag().hashCode();
    }
}
